// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef SCHEDULEENTRYITEM_H
#define SCHEDULEENTRYITEM_H

#include "data/scheduleentry.h"
#include "data/cinema.h"
#include "data/movie.h"

#include <QMetaType>

class ScheduleEntryItem {
public:
    ScheduleEntryItem();
    ScheduleEntryItem(QDate schedule_date);
    ScheduleEntryItem(const ScheduleEntry &schedule_entry);
    ScheduleEntryItem(const ScheduleEntryItem &);
    ScheduleEntryItem &operator=(const ScheduleEntryItem &);
    bool IsScheduleDateItem() const { return _is_schedule_date_item; }
    QDate GetScheduleDate() const { return _schedule_date; }
    const ScheduleEntry *GetScheduleEntry() const { return &_schedule_entry; }
private:
    bool _is_schedule_date_item;
    QDate _schedule_date;
    ScheduleEntry _schedule_entry;
    Movie _movie;
    Cinema _cinema;
};

Q_DECLARE_METATYPE(ScheduleEntryItem);

#endif // SCHEDULEENTRYITEM_H
