// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef SCHEDULEENTRYKEY_H
#define SCHEDULEENTRYKEY_H

#include "data/cinemakey.h"
#include "data/moviekey.h"

#include <QTime>
#include <QDate>
#include <QMetaType>

class ScheduleEntryKey
{
public:
    ScheduleEntryKey() {}
    ScheduleEntryKey(const CinemaKey &cinema_key, const MovieKey &movie_key, const QTime &start_time, const QDate &date);

    CinemaKey GetCinemaKey() const { return _cinema_key; }
    void SetCinemaKey(const CinemaKey &cinema_key) { _cinema_key = cinema_key; }

    MovieKey GetMovieKey() const { return _movie_key; }
    void SetMovieKey(const MovieKey &movie_key) { _movie_key = movie_key; }

    QTime GetStartTime() const { return _start_time; }
    void SetStartTime(const QTime &start_time) { _start_time = start_time; }

    QDate GetDate() const { return _date; }
    void SetDate(const QDate &date) { _date = date; }

private:
    CinemaKey _cinema_key;
    MovieKey _movie_key;
    QTime _start_time;
    QDate _date;
};

Q_DECLARE_METATYPE(ScheduleEntryKey);

bool operator==(const ScheduleEntryKey &lhs, const ScheduleEntryKey &rhs);

uint qHash(const ScheduleEntryKey &);

#endif // SCHEDULEENTRYKEY_H
