// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef CINEMAKEY_H
#define CINEMAKEY_H

#include <QString>
#include <QMetaType>

class CinemaKey
{
public:
    CinemaKey() {}
    CinemaKey(const QString &name, const QString &address);

    QString GetName() const { return _name; }
    void SetName(const QString &name) { _name = name; }

    QString GetAddress() const { return _address; }
    void SetAddress(const QString &address) { _address = address; }

private:
    QString _name;
    QString _address;
};

bool operator==(const CinemaKey &lhs, const CinemaKey &rhs);

uint qHash(const CinemaKey &);

Q_DECLARE_METATYPE(CinemaKey);

#endif // CINEMAKEY_H
