// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef ASYNCCALLCLIENT_H
#define ASYNCCALLCLIENT_H

#include <QObject>

namespace AsyncCallPrivate {

    class CallProxyBase;
    class AsyncCallProxy;

    class AsyncCallClient : public QObject
    {
        Q_OBJECT

    public:
        explicit AsyncCallClient(QThread *proxy_thread, QObject *parent = 0);

    public:
        void Call(CallProxyBase *);

    private:
        Q_SIGNAL void CallAsync(CallProxyBase *);

    private:
        AsyncCallProxy *_proxy;
    };
}

#endif // ASYNCCALLCLIENT_H
