// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MOVIESEARCHCLIENT_H
#define MOVIESEARCHCLIENT_H

#include "abstractsearchclient.h"
#include "searchclientsemaphore.h"

class CinemaSchedule;

class MovieSearchClient : public AbstractSearchClient
{
    Q_OBJECT
public:
    explicit MovieSearchClient(CinemaSchedule *cinema_schedule, QObject *parent = 0);

    void SearchMovie(const QString &town);

    static void CancelAllRunningSearchs();

private:
    void Search(int start);
    Q_SLOT virtual void ReplyFinished(QNetworkReply *);

private:
    CinemaSchedule *_cinema_schedule;
    QString _town;
    static SearchClientSemaphore _semaphore;
};

#endif // MOVIESEARCHCLIENT_H
