// Copyright 2010 Jochen Becher
//
// This file is part of MovieSchedule.
//
// MovieSchedule is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// MovieSchedule is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with MovieSchedule.  If not, see <http://www.gnu.org/licenses/>.

#ifndef MOVIESCHEDULESEARCHCLIENT_H
#define MOVIESCHEDULESEARCHCLIENT_H

#include "abstractsearchclient.h"
#include "searchclientsemaphore.h"
#include "data/moviekey.h"

#include <QUrl>
#include <QQueue>
#include <QSet>
#include <QPair>
#include <QDate>

class CinemaSchedule;
class Movie;

class MovieScheduleSearchClient : public AbstractSearchClient
{
    Q_OBJECT
public:
    explicit MovieScheduleSearchClient(CinemaSchedule *cinema_schedule, QObject *parent = 0);

    void SearchSchedule(const MovieKey &movie_key, const QString &url);

    static void CancelAllRunningSearchs();

private:
    void Search(int start);
    void SearchNextDate();
    Q_SLOT virtual void ReplyFinished(QNetworkReply *);

private:
    CinemaSchedule *_cinema_schedule;
    MovieKey _movie_key;
    QDate _date;
    QUrl _url;
    QSet<QString> _dates_seen;
    QQueue<QPair<QUrl, QDate> > _date_urls;
    static SearchClientSemaphore _semaphore;
};

#endif // MOVIESCHEDULESEARCHCLIENT_H
