#-------------------------------------------------
#
# Project created by QtCreator 2010-03-01T19:21:07
#
#-------------------------------------------------

QT       += core gui network dbus

CONFIG += link_pkgconfig

maemo5 {
    QT += maemo5
    DEFINES += Q_WS_MAEMO_5
    maemo_sdk {
        CONFIG += icd2
        PKGCONFIG += calendar-backend liblocation
        DEFINES += MAEMO_SDK LIBLOCATION
    }
}

mobility {
    MOBILITY += location
    DEFINES += QT_MOBILITY
    !contains(DEFINES, LIBLOCATION) {
        DEFINES += QT_MOBILITY_LOCATION
    }
}

TARGET = movie-schedule
TEMPLATE = app

INCLUDEPATH += .

SOURCES += \
    main.cpp \
    control/actioncontroller.cpp \
    control/maincontroller.cpp \
    control/moviecontroller.cpp \
    control/settingscontroller.cpp \
    control/theatercontroller.cpp \
    data/cinema.cpp \
    data/cinemakey.cpp \
    data/cinemaschedule.cpp \
    data/location.cpp \
    data/movie.cpp \
    data/moviekey.cpp \
    data/scheduleentry.cpp \
    data/scheduleentrykey.cpp \
    data/settings.cpp \
    searchclients/abstractsearchclient.cpp \
    searchclients/movieschedulesearchclient.cpp \
    searchclients/moviesearchclient.cpp \
    searchclients/theaterschedulesearchclient.cpp \
    searchclients/theatersearchclient.cpp \
    ui/abstractmainwindow.cpp \
    ui/backgroundlabel.cpp \
    ui/cinemapainter.cpp \
    ui/contextdialog.cpp \
    ui/daypainter.cpp \
    ui/locationdialog.cpp \
    ui/mainwindow.cpp \
    ui/moviedelegate.cpp \
    ui/moviemodel.cpp \
    ui/moviepainter.cpp \
    ui/moviescheduledelegate.cpp \
    ui/movieschedulemodel.cpp \
    ui/moviewindow.cpp \
    ui/ratingprovider.cpp \
    ui/theaterdelegate.cpp \
    ui/theatermodel.cpp \
    ui/theaterscheduledelegate.cpp \
    ui/theaterschedulemodel.cpp \
    ui/theaterwindow.cpp \
    ui/uiutils.cpp \
    utils/assertedlock.cpp \
    utils/assertedlocker.cpp \
    utils/calendar.cpp \
    utils/timeutils.cpp \
    movieschedule.cpp \
    ui/scheduleentryitem.cpp \
    control/itemmodelsortcontroller.cpp \
    control/itemmodelsortclient.cpp \
    control/itemmodelsortproxy.cpp \
    utils/asynccallclient.cpp \
    utils/asynccallproxy.cpp \
    utils/asynccall.cpp \
    ui/styleutils.cpp \
    searchclients/gpsclient.cpp \
    ui/aboutdialog.cpp \
    searchclients/searchclientsemaphore.cpp \
    control/locationcontroller.cpp \
    utils/connectivitymanager.cpp

HEADERS  += \
    control/actioncontroller.h \
    control/maincontroller.h \
    control/moviecontroller.h \
    control/settingscontroller.h \
    control/theatercontroller.h \
    data/cinema.h \
    data/cinemakey.h \
    data/cinemaschedule.h \
    data/location.h \
    data/movie.h \
    data/moviekey.h \
    data/scheduleentry.h \
    data/scheduleentrykey.h \
    data/settings.h \
    searchclients/abstractsearchclient.h \
    searchclients/movieschedulesearchclient.h \
    searchclients/moviesearchclient.h \
    searchclients/theaterschedulesearchclient.h \
    searchclients/theatersearchclient.h \
    ui/abstractmainwindow.h \
    ui/backgroundlabel.h \
    ui/cinemapainter.h \
    ui/contextdialog.h \
    ui/daypainter.h \
    ui/locationdialog.h \
    ui/mainwindow.h \
    ui/moviedelegate.h \
    ui/moviemodel.h \
    ui/moviepainter.h \
    ui/moviescheduledelegate.h \
    ui/movieschedulemodel.h \
    ui/moviewindow.h \
    ui/ratingprovider.h \
    ui/theaterdelegate.h \
    ui/theatermodel.h \
    ui/theaterscheduledelegate.h \
    ui/theaterschedulemodel.h \
    ui/theaterwindow.h \
    ui/uiutils.h \
    utils/assertedlock.h \
    utils/assertedlocker.h \
    utils/calendar.h \
    utils/timeutils.h \
    utils/connect.h \
    movieschedule.h \
    ui/scheduleentryitem.h \
    control/itemmodelsortcontroller.h \
    control/itemmodelsortclient.h \
    control/itemmodelsortproxy.h \
    utils/asynccallclient.h \
    utils/asynccallproxy.h \
    utils/asynccall.h \
    ui/styleutils.h \
    searchclients/gpsclient.h \
    ui/aboutdialog.h \
    searchclients/searchclientsemaphore.h \
    control/locationcontroller.h \
    utils/connectivitymanager.h

FORMS    += \
    ui/theaterwindow.ui \
    ui/mainwindow.ui \
    ui/locationdialog.ui \
    ui/moviewindow.ui \
    ui/contextdialog.ui \
    ui/aboutdialog.ui

RESOURCES += \
    resources.qrc

TRANSLATIONS += \
    translations/movie-schedule_de.ts

OTHER_FILES += \
    translations/movie-schedule_de.ts \
    ../data/movie-schedule.desktop \
    ../debian/copyright \
    ../debian/control \
    ../debian/changelog \
    ../debian/rules

!isEmpty(TRANSLATIONS) {
    isEmpty(QMAKE_LRELEASE) {
        win32:QMAKE_LRELEASE = $$[QT_INSTALL_BINS]\lrelease.exe
        else:QMAKE_LRELEASE = $$[QT_INSTALL_BINS]/lrelease
    }

    isEmpty(TS_DIR):TS_DIR = translations

    TSQM.name = lrelease ${QMAKE_FILE_IN}
    TSQM.input = TRANSLATIONS
    TSQM.output = $$TS_DIR/${QMAKE_FILE_BASE}.qm
    TSQM.commands = $$QMAKE_LRELEASE ${QMAKE_FILE_IN} -qm $$TS_DIR/${QMAKE_FILE_BASE}.qm
    TSQM.CONFIG = no_link
    QMAKE_EXTRA_COMPILERS += TSQM

    PRE_TARGETDEPS += compiler_TSQM_make_all
}

unix {
    #VARIABLES
    isEmpty(PREFIX) {
        PREFIX = /usr/local
        DEFINES += DEFAULT_PREFIX
    }

    BINDIR = $$PREFIX/bin
    DATADIR =$$PREFIX/share

    DEFINES += DATADIR=\"$$DATADIR\" PKGDATADIR=\"$$PKGDATADIR\"

    #MAKE INSTALL

    INSTALLS += target desktop scalable i18n

    target.path = $$BINDIR

    desktop.path = $$DATADIR/applications/hildon
    desktop.files += ../data/$${TARGET}.desktop

    scalable.path = $$DATADIR/icons/hicolor/scalable/hildon
    scalable.files += ../data/scalable/$${TARGET}.png

    i18n.path = $$DATADIR/$${TARGET}
    i18n.files += ../builddir/src/translations

}
