#!t.icd1_ipinfo(

import dbus, gobject
from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)

class icd_test:
    def __init__(self):
        self.loop = loop = gobject.MainLoop()
        self.bus = dbus.SystemBus()
        self.icd_obj = self.bus.get_object('com.nokia.icd', '/com/nokia/icd')
        self.icd_iface = dbus.Interface(self.icd_obj, 'com.nokia.icd')
        self.icd2_obj = self.bus.get_object('com.nokia.icd2', '/com/nokia/icd2')
        self.icd2_iface = dbus.Interface(self.icd2_obj, 'com.nokia.icd2')
        self.icdui_obj = self.bus.get_object('com.nokia.icd', '/com/nokia/icd_ui')
        self.icdui_iface = dbus.Interface(self.icdui_obj, 'com.nokia.icd_ui')
        self.expect_state_signals = 0


    def icd1_ipinfo(self):
        info = self.icd_iface.get_ipinfo()
        print info

    def icd2_state_listener(self, *args):
        print "icd2_state_listener got args:\n";
        print args
        self.expect_state_signals = self.expect_state_signals -1
        if self.expect_state_signals <= 0:
            self.loop.quit()

    def icd2_state(self):
        self.icd2_obj.connect_to_signal('state_sig', self.icd2_state_listener, 'com.nokia.icd2', byte_arrays=True)
        self.expect_state_signals = self.icd2_iface.state_req()
        self.loop.run()

    def icd2_disconnect(self):
        print "Disconnect"
        #self.icd2_iface.disconnect_req(dbus.UInt32(0)) # ICD_CONNECTION_FLAG_APPLICATION_EVENT 0x0
        self.icd2_iface.disconnect_req(dbus.UInt32(32768)) # ICD_CONNECTION_FLAG_UI_EVENT 0x8000
        #self.icd2_iface.disconnect_req(dbus.UInt32(1)) # ICD_CONNECTION_FLAG_USER_EVENT 0x1

    def icd2_connect(self):
        print "Connect"
        
        # Make connection name into array of bytes
        connection_name = "SONERA Internet"
        connection_array = []
        for char in list(connection_name):
            connection_array.append(dbus.Byte(char))
        connection_array.append(dbus.Byte(0))
        
        # Do the call
        ret = self.icd2_iface.connect_req( 
            #dbus.UInt32(0), # ICD_CONNECTION_FLAG_APPLICATION_EVENT 0x0
            dbus.UInt32(32768), # ICD_CONNECTION_FLAG_UI_EVENT 0x8000
            #dbus.UInt32(1), # ICD_CONNECTION_FLAG_USER_EVENT 0x1
            dbus.Array( # API Documentation seems to be wrong, dbus-monitor shows array of structs and the earlier approach gave exceptions
                [
                    dbus.Struct(
                        [
                            dbus.String(""),
                            dbus.UInt32(0),
                            dbus.String(""),
                            dbus.String("GPRS"),
                            dbus.UInt32(83886080), # CD_NW_ATTR_AUTOCONNECT   0x04000000 & ICD_NW_ATTR_IAPNAME   0x01000000 
                            dbus.Array(connection_array) 
                        ]
                    )
                ] 
            ) 
        )
        print ret


    def icd2_connection_list_listener(self, *args):
        scan_status = args[0]
        network_type = args[7]
        network_name = args[8]
        print "icd2_connection_list_listener saw: " + repr(str(network_name)) + " (type: " + repr(str(network_type)) + " status: " + repr(int(scan_status)) + ")"
        self.connections.append(args)
        if int(scan_status) == 4:
            # Scan done, documentation scan restarts after timeout so I suppose we should explicitly cancel it...
            self.icd2_iface.scan_cancel_req()
            # run mainloop only when needed, in GUI applications this is obviously taken care of by the toolkit...
            self.loop.quit()
            pass

    def icd2_connection_list(self):
        import pprint
        self.connections = []

        self.icd2_obj.connect_to_signal('scan_result_sig', self.icd2_connection_list_listener, 'com.nokia.icd2', byte_arrays=True)
        req = self.icd2_iface.scan_req(
            #dbus.UInt32(0), # ICD_SCAN_REQUEST_ACTIVE 0x0
            dbus.UInt32(1), # ICD_SCAN_REQUEST_ACTIVE_SAVED 0x1
            dbus.Array(
                [
                    dbus.String("GPRS"),
                ]
            )
        )
        pprint.pprint(req)
        # run mainloop only when needed, in GUI applications this is obviously taken care of by the toolkit...
        self.loop.run()
        print "Connections:"
        pprint.pprint(self.connections)
        

if __name__ == "__main__":
    t = icd_test()
    t.icd2_state()
