
#include <microfeed-common/microfeedconfiguration.h>
#include <microfeed-common/microfeedprotocol.h>
#include <microfeed-common/microfeeditem.h>
#include <microfeed-provider/microfeeddatabase.h>
#include <microfeed-common/microfeedobject.h>

#include <sys/types.h>
#include <stdint.h>
#include <stdio.h>
#include <glib.h>

int main(int argc, char** argv) {
	MicrofeedConfiguration* configuration;
	GKeyFile* key_file;
	const char** publishers;
	const char* directory;
	MicrofeedDatabaseEnvironment* database_environment;
	MicrofeedDatabase* database;
	MicrofeedDatabaseIterator* iterator;
	const void* key;
	size_t key_size;
	const void* data;
	size_t data_size;
	MicrofeedItem* item;
	
	microfeed_thread_init();
	
	configuration = microfeed_configuration_new();
	key_file = g_key_file_new();

	for (publishers = microfeed_configuration_get_publishers(configuration);
	     *publishers;
	     publishers++) {
		directory = microfeed_configuration_get_publisher_directory(configuration, *publishers);
		database_environment = microfeed_database_environment_new(*publishers, directory);
		database = microfeed_database_environment_get_database(database_environment, MICROFEED_FEED_URI_SETTINGS, 0, 0);
		for (iterator = microfeed_database_iterate(database, 0, 0, 0);
		     microfeed_database_iterator_get(iterator, &key, &key_size, &data, &data_size);
		     microfeed_database_iterator_next(iterator)) {
			item = microfeed_item_new(key + sizeof(uint64_t), (time_t)(*((uint64_t*)key)));
			microfeed_item_demarshal_properties(item, data, data_size);
			printf("%s: %s\n", microfeed_item_get_uid(item), microfeed_item_get_property(item, MICROFEED_ITEM_PROPERTY_NAME_SETTING_VALUE));
			microfeed_item_free(item);
		}
		microfeed_object_unref(database, MicrofeedDatabase);
		microfeed_object_unref(database_environment, MicrofeedDatabaseEnvironment);
	}

	microfeed_configuration_free(configuration);
	g_key_file_free(key_file);	

	return 0;
}
