# -*- coding: utf-8 -*-
'''
MediaBox Home Widget Config
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''
import os, os.path

from mediaboxwidgetlib.core.constants import *
from advpowcommon.util.config import Config
from advpowcommon.util.singleton import Singleton

class MediaBoxConfig(Config, Singleton):

  def __init__(self, settings_path):
    Config.__init__(self, settings_path)
    Singleton.__init__(self)
    self.set_options({'orientation': ['automatic', 'portrait', 'landscape'],
                      'repeat_mode': ['none', 'one', 'all'],
                      'shuffle_mode': ['none', 'one'],
                      'theme': self.__list_themes(),
                      'system/keep-display-lit': ['no', 'playing'],
                      'system/phonecall-resume': ['manual', 'automatic'],
                      'youtube/quality': ['low', 'high', 'ask']
                     })

  def load(self):
    Config.load(self)
    self.set_option('theme', self.__list_themes())

  def __list_themes(self):
    themes = [f for f in os.listdir(MEDIABOX_THEMES_PATH) if os.path.isdir(os.path.join(MEDIABOX_THEMES_PATH, f))]
    themes.sort()
    return themes

__mediabox_config_singleton = MediaBoxConfig('/apps/maemo-mediabox')
def get_mediabox_config(): return __mediabox_config_singleton

class MBHWConfig(Config, Singleton):

  def __init__(self, settings_path):
    Config.__init__(self, settings_path)
    Singleton.__init__(self)

__config_singleton = MBHWConfig('/apps/mediabox-home-widget')
def get_config(): return __config_singleton
