# -*- coding: utf-8 -*-
'''
MediaBox Widget UI Theme
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Theme support for applet.
'''
import os, os.path

from mediaboxwidgetlib.core.constants import *
from mediaboxwidgetlib.util.config import *
from advpowcommon.util.common import *
from advpowcommon.util.singleton import Singleton


class Theme(Singleton):

  themes_path = MEDIABOX_THEMES_PATH
  theme_def_ext = '.def'
  image_prefix = 'mb_'
  image_ext = '.png'

  _config = get_mediabox_config()

  def __init__(self, alpha=0.6):
    Singleton.__init__(self)
    self.__name = self._config.get_value('theme')
    if not self.__name:
      self.__name = 'kuro'
    self.__alpha = alpha

    theme_dir = os.path.join(self.themes_path, 'default')
    theme_dir_content = os.listdir(theme_dir)
    self.__files = [f for f in theme_dir_content if os.path.isfile(os.path.join(theme_dir, f))]
    self.__config = {}
    self.load()

  def load(self):
    self.__config.clear()
    for f in self.__files:
      if f.endswith(self.theme_def_ext):
        self.__parse_def_file(self.__get_file_path(f))
      elif f.startswith(self.image_prefix) and f.endswith(self.image_ext):
        self.__parse_image_file(self.__get_file_path(f))

  def set_theme(self, theme):
    self.__name = theme
    self.load()

  def __get_file_path(self, cfile):
    if cfile:
      file_path = os.path.join(self.themes_path, self.__name, cfile)
      if not(os.path.exists(file_path) and os.path.isfile(file_path)):
        file_path = os.path.join(self.themes_path, 'default', cfile)
      return file_path
    else:
      return None

  def __parse_def_file(self, cfile):
    lines = get_file_lines(cfile)
    for l in lines:
      type_ind = l.find('_')
      value_ind = l.rfind(':')
      self.__add_config_value(l[0:type_ind], l[type_ind+1:value_ind], l[value_ind+1:])

  def __parse_image_file(self, cfile):
    prefix_ind = cfile.find(self.image_prefix)
    ext_ind = cfile.rfind(self.image_ext)
    self.__add_config_value('image', cfile[prefix_ind+len(self.image_prefix):ext_ind], cfile)

  def __add_config_value(self, group, name, value):
    group = group.strip()
    name = name.strip()
    value = value.strip()
    if not group in self.__config:
      self.__config[group] = {}
    self.__config[group][name] = value

  def get_color(self, key):
    try:
      return self.__config['color'][key]
    except KeyError:
      return None

  def get_font(self, key):
    try:
      return self.__config['font'][key]
    except KeyError:
      return None

  def get_image(self, key):
    if key.startswith('/'):
      return key
    else:
      try:
        return self.__config['image'][key]
      except KeyError:
        return None

  def get_alpha(self):
    return self.__alpha

  def get_themes_path(self):
    return self.themes_path

theme_singleton = Theme()

def get_theme(): return theme_singleton
