# -*- coding: utf-8 -*-
'''
MediaBox Widget UI Scrolling Text
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gobject
from mediaboxwidgetlib.ui.Widgets import Widget
from advpowcommon.ui.Cairo import Cairo

class ScrollingText(Widget):

  SCROLL_RIGHT = 1
  SCROLL_LEFT = SCROLL_RIGHT * -1
  NO_SCROLL = 0

  def __init__(self, name, size, text='', font_size=None):
    Widget.__init__(self, name, size)
    if font_size:
      self.font_size = font_size
    else:
      self.font_size = self.size_height
    self.__set_c_text(text)
    self.__text_pos = 0
    self.__text_width = 0
    self.__text_height = self.size_height
    self.__x_bearing = 0
    self.__y_bearing = 0
    self.__timer = None
    self.__scrollto = self.NO_SCROLL
    self.__check_size = True
    self.__scrolling_pause = 5000
    self.__scrolling_timeout = 75
    self.connect('destroy', self.stop_timer)

  def draw(self, cr):
    if self.__c_text:
      try:
        if self.__check_size:
          try:
            x_bearing, y_bearing, t_width, t_height, x_advance, y_advance = Cairo.get_text_size(cr, self.__c_text, self.font_size)
            self.__text_width = t_width + ((t_width + x_bearing) % self.SCROLL_RIGHT) + x_bearing
            self.__text_height = t_height
            self.__x_bearing = x_bearing
            self.__text_y = (self.size_height - self.font_size)/2 - y_bearing
          except Exception, e:
            self.__c_text = str(e)
            self.__text_width = 0
            self.__scrollto = self.NO_SCROLL
          self.start_timer()
          self.__check_size = False
        Cairo.draw_text_at_pos(cr, self.__c_text, self.font_size, self.__text_pos, self.__text_y, self._theme.get_color('mb_text'))
      except Exception, e:
        pass
    return False

  def __set_c_text(self, text):
    self.__c_text = text

  def set_text(self, text):
    if not(self.__c_text == text):
      self.stop_timer()
      self.__set_c_text(text)
      self.__check_size = True
      self.__text_pos = self.SCROLL_LEFT
      self.__scrollto = self.SCROLL_RIGHT
    self.redraw(True)

  def __scroll_text(self):
    if self.active:
      if self.__scrollto == self.SCROLL_LEFT and self.size_width == self.__text_width + self.__text_pos:
        self.__scrollto = self.SCROLL_RIGHT
        self.stop_timer()
        self.restart_timer(self.__scrolling_pause)
        return False
      elif self.__scrollto == self.SCROLL_RIGHT and self.__text_pos == 0:
        self.__scrollto = self.SCROLL_LEFT
        self.stop_timer()
        self.restart_timer(self.__scrolling_pause)
        return False
      elif self.__scrollto == self.NO_SCROLL:
        self.set_text(self.__c_text)
        return False
      if self.size_width < self.__text_width:
        self.__text_pos += self.__scrollto
      else:
        self.__text_pos = 0
    self.redraw()
    return self.size_width < self.__text_width

  def start_timer(self):
    if not self.__timer:
      self.__timer = gobject.timeout_add(self.__scrolling_timeout, self.__scroll_text)
    return False

  def stop_timer(self, widget=None):
    if self.__timer:
      gobject.source_remove(self.__timer)
      self.__timer = None
    return False

  def restart_timer(self, timeout=0):
    self.stop_timer()
    if timeout:
      gobject.timeout_add(timeout, self.start_timer)
    else:
      gobject.idle_add(self.start_timer)
