# -*- coding: utf-8 -*-
'''
MediaBox Widget
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Maemo 5 home item
'''

import gtk, hildon
from abstract import AbstractMediaBoxWidget
from hildondesktop import HomePluginItem
from advpowcommon.ui.Config import ConfigUIMaemo5
from advpowcommon.ui.Notebook import NotebookMaemo5

class MediaBoxWidgetMaemo5(AbstractMediaBoxWidget, HomePluginItem):

  def __init__(self):
    AbstractMediaBoxWidget.__init__(self)

  def __super_init__(self):
    HomePluginItem.__init__(self)

  def __custom_init__(self):
    self.set_settings(True)
    self.connect('property-notify-event', self.on_current_desktop)
    self.connect('show-settings', self.show_settings_dialog)

  def __show_all__(self):
    self.widget_box.show_all()

  def __get_configui__(self):
    return ConfigUIMaemo5()

  def __get_notebook__(self):
    return NotebookMaemo5()

  def on_current_desktop(self, widget, event):
    if event.atom == '_HILDON_APPLET_ON_CURRENT_DESKTOP':
      self.update_widgets_activity(event.state.value_nick == 'new-value')
    return False

  def do_realize(self):
    self.screen_changed(self)
    HomePluginItem.do_realize(self)
    return False

def get_hd_plugin_type(): return MediaBoxWidgetMaemo5