#! /usr/bin/env python
# -*- coding: UTF-8 -*-

import os, sys, time, ConfigParser

DEBUG = True

CONFIG_PATH           = '/home/user/.media-im-status-updater.ini'
RTCOM_ACCOUNTS_CONFIG = '/home/user/.rtcom-accounts/accounts.cfg'
HILDON_ICON_PATH      = '/opt/usr/share/icons/hicolor/48x48/hildon'
RTCOM_PROFILES_PATH   = '/usr/share/osso-rtcom'

IGNORE_ACCOUNTS = ['ring/tel/ring']

MEDIA_PROFILES  = [
  # Label, Icon, (default) Enabled, (default) Template
  (u'Music', 'general_audio_file',          False, u'Listening to "%t" by "%a" via Nokia N900'),
  (u'Radio', 'mediaplayer_internet_radio',  False, u'Streaming "%o" @ "%t" via Nokia N900'),
  (u'Video', 'general_video_file',          False, u'Watching "%f" via Nokia N900')
]

def debug(message):
  if DEBUG and sys.stderr.isatty():
    sys.stderr.write('[%f] %s\n' % (time.time(), message))

def enclosure(f, *args):
  return lambda *i: f(*(i + args))

class Config:
  def __init__(self, path):
    self.__path       = path

    self.__is_enabled = dict()
    self.__templates  = dict()
    self.__accounts   = dict()

    for profile,icon,enabled,template in MEDIA_PROFILES:
      self.__is_enabled[profile]  = enabled
      self.__templates[profile]   = template
      self.__accounts[profile]    = []

  def is_enabled(self, profile):
    return self.__is_enabled[profile]

  def template(self, profile):
    return self.__templates[profile]

  def accounts(self, profile):
    return self.__accounts[profile]

  def set_enabled(self, profile, is_enabled, save = True):
    self.__is_enabled[profile] = is_enabled
    self.__conditional_save(save)

  def set_template(self, profile, template, save = True):
    self.__templates[profile] = template
    self.__conditional_save(save)

  def load(self):
    if os.path.isfile(self.__path):
      parser = ConfigParser.RawConfigParser()
      parser.read(self.__path)

      for profile,icon,enabled,template in MEDIA_PROFILES:
        try:
          self.__is_enabled[profile]  = parser.get(profile, 'Enabled').lower() == 'true'
          self.__templates[profile]   = parser.get(profile, 'Template')

          accts = parser.get(profile, 'Accounts').strip()

          if len(accts) > 0:
            self.__accounts[profile]  = accts.split(',')

        except ConfigParser.NoSectionError, ConfigParser.NoOptionError:
          pass

  def save(self):
    parser = ConfigParser.RawConfigParser()

    for profile,icon,enabled,template in MEDIA_PROFILES:
      parser.add_section(profile)
      parser.set(profile, 'Enabled',  str(self.__is_enabled[profile]))
      parser.set(profile, 'Template', self.__templates[profile])
      parser.set(profile, 'Accounts', str.join(',', self.__accounts[profile]))

    f = open(self.__path, 'w')
    parser.write(f)
    f.close()

  def __conditional_save(self, save):
    if save:
      self.save()

