#! /usr/bin/env python
# -*- coding: UTF-8 -*-

import sys, dbus

DEBUG                 = False

MAFW_RENDERER_PATH    = '/com/nokia/mafw/renderer/gstrenderer'
MAFW_RENDERER_IFACE   = 'com.nokia.mafw.renderer'

MAFW_STATE_STOPPED    = 0
MAFW_STATE_STARTED    = 1
MAFW_STATE_PAUSED     = 2
MAFW_STATE_TRANSITION = 3

def debug(message):
  if DEBUG and sys.stderr.isatty():
    sys.stderr.write("[%f] %s\n" % (time.time(), str(message)))

class IMediaMonitor:
  def on_metadata(self, key, value):
    pass

  def on_media_started(self):
    pass

  def on_media_stopped(self):
    pass

  def on_media_paused(self):
    pass

  def on_media_transition(self):
    pass

class MafwMonitor(IMediaMonitor):
  __object_path = None
  __session_bus = None

  def __init__(self, bus, object_path = MAFW_RENDERER_PATH):
    self.__session_bus  = bus
    self.__object_path  = object_path

    self.__session_bus.add_signal_receiver(self._on_state_changed,
                                           path = self.__object_path,
                                           dbus_interface = MAFW_RENDERER_IFACE,
                                           signal_name = 'state_changed')

    self.__session_bus.add_signal_receiver(self._on_metadata_changed,
                                           path = self.__object_path,
                                           dbus_interface = MAFW_RENDERER_IFACE,
                                           signal_name = 'metadata_changed')

  def _on_state_changed(self, state):
    if    state == MAFW_STATE_STOPPED:
      self.on_media_stopped()

    elif  state == MAFW_STATE_STARTED:
      self.on_media_started()

    elif  state == MAFW_STATE_PAUSED:
      self.on_media_paused()

    elif  state == MAFW_STATE_TRANSITION:
      self.on_media_transition()

    else:
      debug('WARN: Unknown state: %d' % state)

  def _on_metadata_changed(self, key, state, data):
    self.on_metadata(key, data)

if __name__ == '__main__':
  import gobject, dbus.glib

  DEBUG = True

  class MyMonitor(MafwMonitor):
    def on_metadata(self, key, value):
      debug('INFO: metadata %s: %s' % (key, value))

    def on_media_started(self):
      debug('INFO: media started')

    def on_media_stopped(self):
      debug('INFO: media stopped')

    def on_media_paused(self):
      debug('INFO: media paused')

    def on_media_transition(self):
      debug('INFO: media transitioning')

  bus     = dbus.SessionBus()
  service = MyMonitor(bus)

  main = gobject.MainLoop()
  main.run()

