/**
 * maemo-barcode - barcode detection/recognition application
 *
 * Copyright (c) 2008 Simon Pickering <S.G.Pickering@bath.ac.uk>
 *
 * Various parts of barcode recognition and GStreamer manipulation code written by:
 *       Timothy Terriberry
 *       Adam Harwell
 *       Jonas Hurrelmann
 *
 * Original GStreamer code based on the maemo-examples package
 * Copyright (c) 2007-2008 Nokia Corporation. All rights reserved.
 * Copyright (c) 2006 INdT.
 * @author Talita Menezes <talita.menezes@indt.org.br>
 * @author Cidorvan Leite <cidorvan.leite@indt.org.br>
 * @author Jami Pekkanen <jami.pekkanen@nokia.com>
 */

#ifndef DECODER_H
#define DECODER_H

#include <gtk/gtk.h>
#include <hildon/hildon-banner.h>
#include <hildon/hildon-program.h>


#define MAX_VOTES 10
#define SCAN_TIME 3
#define WINNING_VOTES 2


gboolean analyse_image(unsigned char *data, unsigned char **output);

void libdmtx_thread_main();

#ifndef USE_ZBAR
int batoo_analyse_image(unsigned char *buffer, unsigned char **output, int width, int height);
int derfQR_analyse_image(unsigned char *img, unsigned char **output, int width, int height);
#endif /* USE_ZBAR */

int libdmtx_analyse_image(unsigned char *data, unsigned char **output, int width, int height);
void init_dmtx_thread();

#endif

