/*
  sudokuselectnumberwidget.h
  Project: masudoku
  Platform: Fremantle (maemo5)
  Author: Petri Kultanen pete@petnetti.net
  Last Edit: 15.2.2010
*/
#ifndef SUDOKUSELECTNUMBERWIDGET_H
#define SUDOKUSELECTNUMBERWIDGET_H

#include <QWidget>
class CSudokuTable;
class QPaintEvent;
class QMouseEvent;
enum NumberTypes
{
    ENormalNumbers =0,
    EMarkupNumbers=1
};

class SudokuSelectNumberWidget : public QWidget
{
public:
    SudokuSelectNumberWidget();
    Q_OBJECT
public:
    void setTable(CSudokuTable *aTable);
    void paintEvent(QPaintEvent *aEvent);
    void mousePressEvent(QMouseEvent * aEvent);
    void setCoordinates(int aX,int aY);
    void setSettingNumberHints(bool aBool);
    void setSettingMarkupOrNormalNumbers(NumberTypes aType);
signals:
    void numberSelected(int aNum);
private:
    CSudokuTable *iTable;
    int iX;
    int iY;
    bool iSettingNumberHints;
    int iNumberType;
};

#endif // SUDOKUSELECTNUMBERWIDGET_H
