/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef STONE_H
#define STONE_H

#include <QtSvg/QGraphicsSvgItem>


class GameInfo;
class ThemeManager;
class Board;

class Stone : public QGraphicsSvgItem{
    Q_OBJECT
    public:

        Stone(int index, GameInfo* gameInfo, ThemeManager* theme, QGraphicsSvgItem *parent);
        void initialSetup();

        void setSize(QSizeF size){ m_size = size;}

        QSizeF size() const{ return m_size;}
        int index() const{ return m_index;}

        void animateStones(QPointF);
        void setPosition(qreal x, qreal y);

    signals:
        void nothing();


    protected:

    private:

        int m_index;
        QSizeF m_size;
        QPointF m_pos;
        Board* m_board;

        ThemeManager *m_themeManager;
        GameInfo *m_gameInfo;
};

#endif // STONE_H
