/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "Stone.h"
#include <math.h>

#include <QSvgRenderer>
#include <QGraphicsItemAnimation>
#include <QTimeLine>

// #include "kdebug.h"
// #include "kstandarddirs.h"

#include "Board.h"


//Stone::Stone(int index , QSvgRenderer *render,  GameInfo* gameInfo, ThemeManager* theme)
Stone::Stone(int index , GameInfo* gameInfo, ThemeManager* theme,QGraphicsSvgItem *parent)
    : QGraphicsSvgItem(parent)

{
    m_themeManager = theme;
    m_gameInfo = gameInfo;
    m_board = qgraphicsitem_cast<Board*>(parent);

    setSharedRenderer((QSvgRenderer*)theme);
    setElementId("stone");

    m_index = index;
    setZValue(3);

}

void Stone::setPosition(qreal x, qreal y){

    m_pos.setX(x);
    m_pos.setY(y);

    //kDebug() << "Pos Here: " << x << " " << y;
    setPos(x,y);

}

void Stone::animateStones(QPointF newPos){

    //kDebug() << "Stone Pos: New: "<< newPos << " Old: " << m_pos;
    int steps = abs(m_pos.x() - newPos.x()) + abs(m_pos.y() - newPos.y()),diff;

    QTimeLine *timer = new QTimeLine(1000);
    timer->setFrameRange(0, 100);

    QGraphicsItemAnimation *animation = new QGraphicsItemAnimation;
    animation->setItem(this);
    animation->setTimeLine(timer);

    for (int i = 0; i < (int)steps; ++i){

        if(i < abs(m_pos.x() - newPos.x()) ){
            if( m_pos.x() < newPos.x() ){
                animation->setPosAt(i / (qreal)steps, QPointF( i + m_pos.x() , m_pos.y()));
                //kDebug() << "Position: " << QPointF( i + m_pos.x() , m_pos.y());
            }
            else animation->setPosAt(i / (qreal)steps, QPointF( m_pos.x() - i , m_pos.y()));
            diff = i;
        }
        else{
            //if( diff+1 == i) kDebug() <<"Diff is:" << diff;

            if(m_pos.y() < newPos.y()){
                animation->setPosAt( i/ (qreal) steps, QPointF(newPos.x() , i-diff+m_pos.y() ));
                //kDebug() << "Position: " << QPointF(newPos.x() , i-diff+m_pos.y() );
            }
            else{
                animation->setPosAt( i/ (qreal) steps, QPointF(newPos.x() , m_pos.y()-(i-diff) ));
                //kDebug() << "Position: " << QPointF(newPos.x() , m_pos.y()-(i-diff));
            }
        }
    }

    timer->start();

    m_pos.setX(newPos.x());
    m_pos.setY(newPos.y());

}
