/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GAMEINFO_H
#define GAMEINFO_H

#include <QXmlStreamReader>
#include <QList>
#include <QPair>

//Store the necessary info of game. For example, num of rows, cup per row, num of stone
//initially etc.

class GameInfo : public QXmlStreamReader{
    public:
        GameInfo();
        ~GameInfo();
//enums
        enum Rotation{ CLOCKWISE,ANTICLOCKWISE,COMPLICATED };
        //PUlll Across - captured pieces statrs from player's side(omweso)
        enum Capture{ CROSS,COUNT,SERIES,PULL_ACCROSS };
        enum Side{ NONE,OWN,OPPONENT,BOTH };
        enum Lap{ SINGLE, MULTIPLE, PUSSA_KANAWA};
        enum GameType{TRADITIONAL,MODERN,CUSTOM};
        enum CountCapture{NUMBER,PATTERN};
        enum SeriesCapture{ FOLLOWING,PRECEDING};
        enum GrandSlam{ INVALID,NO_CAPTURE,CAPTURE,PENALTY };
        enum WinCondition{ TOTAL_STONE,DISABLING_OPPONENT,GOING_EMPTY };
        enum Pattern{EVEN,ODD};
        enum Direction{LEFT,RIGHT};

//functions
        void initializeAll();

        int numCupsPerRow() const{ return m_cups_per_row; }
        int numRows() const{ return m_num_rows; }
        int numKalahs() const{ return m_num_kalahs; }
        int initialStonesPerCup() const{ return m_initial_stones_per_cup; }
        int stones() const{ return m_initial_stones_per_cup * m_num_rows * m_cups_per_row;}
        Rotation rotationType() const{ return m_rotation_type;}
        int stonesToKalah() const{ return m_stones_to_kalah;}
        int leftToCup() const{ return m_left_stone_to_cup;}
        bool omitCup() const{return m_omit_initial_cup;}
        int lapStyle() const{ return m_lap_style;}
        int stonesToEndLap() const{ return m_stones_to_end_lap;}
        bool isBonusTurn() const{ return m_bonus_turn;}
        int specialFlag() const{ return m_special_flags;}

        void setGameInfo(QString file);
        void parseXmlFile( QIODevice *device );
        void setLogicalBoard();

        int captureType(){return m_capture_types;}
        QList< QPair<Side,QList<int> > > captureInfo(){ return m_capture_info;}

        int rotationInfo(int cupIndex){ return m_rotation_cup[cupIndex];}

    protected:

    private:

        GameType m_type;//modern,traditional(default-traditional)
        QString m_region;

        //Board Info
        int m_num_rows;
        int m_cups_per_row;
        int m_initial_stones_per_cup;
        int m_num_kalahs; //In kalah,oware 2

        //Game Info

        //sowing
        Lap m_lap_style;              //which lap style the game follows(default-single)
        //If game has multiple lap, then it ends if the last stone put in kalah(m_stones_to_kalah is not none)
        //or it ends in a cup which has some number of stone
        int m_stones_to_end_lap;      //only for multiple lap
        Side m_side_to_end_lap;         //on which side the cup should be

        Rotation m_rotation_type;    // In kalah,oware anticlockwise(default-anitclockwise)
        QList<Rotation>m_rotation_cup; //For Every cup, there will be a rotation type(bechi)

        Side m_sowing_side;     //from whose side sowing starts for a player(default-own)
        int m_min_stones_to_sow;  //In kalah,oware 1(default-1)
        bool m_omit_initial_cup;   //Is it necessary to omit cup when sowing(default-false)
                                    //it may happen when a cup has more than 2*n-1 stones
                                    //in oware(n->numofcups)
        int m_left_stone_to_cup;    // 0->empty cup, 1->keep 1 stone at house when sowing and so on(default-0)
        bool m_bonus_turn;          //Is bonus turn allowed(default-false)
        Side m_stones_to_kalah;   //default - none


        //capture
        int m_capture_types;  //0th bit-cross, 1st-count, 2nd-series, 3rd-GrandSlam, 4th-PullAcross
        QList< QPair<Side,QList<int> > > m_capture_info; //For every capture, the stone info in cup
        //For example in cross capture(kalah) both,1(the stonenumber in the cup where last stone
        //is put), for count capture(oware) opponent,(GameInfo::NUMBER,2,3)(opponent cup should have 2 or 3 stones to capture)
        //For series capture(oware) opponent,GameInfo::FOLLOWING
        //GrandSlam m_grandslam_option;//If a series capture empties the opponent it is called
        //GrandSlam

        bool m_cup_movement_previously; //needed for bechi when count/series capture (default-false)


        //special rules
        int m_special_flags; // 0th-empty opponent, 1st-turn passing, 2nd-compulsory move
        //Can you keep your opponent empty(default-true)
        //Is Turn passing allowed,if no move(default-true)
        /*Is it must to move, if possible to your opponents pits whe
        he has no stones to move, so that he can continue(default-false)*/

        //end rules
        WinCondition m_win_condition;    //1->by total stones in kalah, 2->by disabling opponent to move,
        //3->by going empty(if he runs out of seeds) default-total

        //Functions
        void parseGame();
        void parseBoard();
        void parseRules();
        void parseSowing();
        void parseCapture();
        void parseSpecialRules();
        void parseEndRules();

        void parseRotation();
        void parseLap();
        void parseLapEnd();

        void parseCrossCapture();
        void parseCountCapture();
        void parseSeriesCapture();
        void parsePullAcrossCapture();

    };

#endif // GAMEINFO_H
