/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "GameInfo.h"

#include <math.h>
#include <QFile>
#include <QStringList>
// #include <kdebug.h>
// #include <kstandarddirs.h>



GameInfo::GameInfo(){

    initializeAll();

}

void GameInfo::initializeAll(){

    //making all list empty
    m_capture_types = 0;
    while(m_capture_info.count())
        m_capture_info.pop_front();
    while(m_rotation_cup.count())
        m_rotation_cup.pop_front();

}

void GameInfo::setGameInfo(QString file){

    QString fileName = QString("/opt/mancala/data/rules/%1.xml").arg(file);
//    kDebug() << "The GameInfo File Name: " << fileName;
    if(fileName.isEmpty()) return;

    QFile infoFile(fileName);
    if (!infoFile.open(QFile::ReadOnly | QFile::Text)) return;
    parseXmlFile(&infoFile);

}

//The parsing operation will be here
void GameInfo::parseXmlFile(QIODevice *device){

    //kDebug() << "Starting of setGameInfo: " ;
    setDevice(device);


    while(!atEnd()){
        readNext();

        if(isStartElement()){

            if(name() == "game"){
                parseGame();
            }
            else raiseError(QObject::tr("This is not the exact file Needed"));
        }
    }

    //kDebug() << "Region: " << m_region;
    //kDebug() << "Game Type: " << m_type;

    //kDebug() << "Row Number " << m_num_rows;
    //kDebug() << "Cup Per Row " << m_cups_per_row;
    //kDebug() << "Kalah Number " << m_num_kalahs;
    //kDebug() << "Initial Stone Per Row " << m_initial_stones_per_cup;

    //kDebug() << "Sowing Information: --------------";
    //kDebug() << "Minimum stone to sow:" << m_min_stones_to_sow;
    //kDebug() << "Left Stone to Cup:" << m_left_stone_to_cup;
    //kDebug() << "Omit Initial Cup:" << m_omit_initial_cup;
    //kDebug() << "stones to kalah:" << m_stones_to_kalah;
    //kDebug() << "Bonus Turn" << m_bonus_turn;

//    kDebug() << "Capture types: " << m_capture_types;

}

void GameInfo::parseGame(){

    Q_ASSERT(isStartElement() && name() == "game");

    while(!atEnd()){
        readNext();

        if(isEndElement())
            break;

        if(isStartElement()){

            if(name() == "type"){
                QString typeString = readElementText();
                if(typeString == "modern")
                    m_type = MODERN;
                else if(typeString == "traditional")
                    m_type = TRADITIONAL;
                else m_type = CUSTOM;
            }
            else if( name() == "region")
                m_region = readElementText();
            else if( name() == "board")
                parseBoard();
            //Other Elements will be here
            else if(name() == "rules")
                parseRules();
            else {
                // kDebug() << "Option that is not still handled";
            }
        }
    }

}

void GameInfo::parseBoard(){

    //kDebug() << " I am here to parseBoard() ";
    //kDebug() << "Name is: " << name();

    Q_ASSERT(isStartElement() && name() == "board");

    while(!atEnd()){
        readNext();

        //kDebug() << "Name is: " << name();
        if(isEndElement())
            break;
        if(isStartElement()){

            if(name() == "row_number"){
                m_num_rows = readElementText().toInt();
            }

            else if(name() == "cup_per_row"){
                m_cups_per_row = readElementText().toInt();
            }

            else if(name() == "kalah_number"){
                m_num_kalahs = readElementText().toInt();
            }

            else if(name() == "initial_stone_number"){
                m_initial_stones_per_cup = readElementText().toInt();
            }
            else {
                // kDebug() << "Option that is not still handled";
            }
        }
    }

    //setCupRotation (default anticlockwise)
    for(int i = 0 ; i < m_num_rows * m_cups_per_row ; i++){
        m_rotation_cup << GameInfo::ANTICLOCKWISE;
        ////kDebug() << "Cup: " << i << " rotation: " << m_rotation_cup[i];
    }

}

void GameInfo::parseRules(){

    Q_ASSERT( isStartElement() && name() == "rules");

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;

        if(isStartElement()){

            if(name() == "sowing")
                parseSowing();
            else if(name() == "capture")
                parseCapture();
            else if(name() == "end_rule")
                parseEndRules();
            else if( name() == "special_rules")
                parseSpecialRules();
            else {
                // kDebug() << "Option that is not still handled";
            }
        }
    }

}

void GameInfo::parseSowing(){

    Q_ASSERT( isStartElement() && name() == "sowing");

    //kDebug() << "I am here to parseSowing()";

    //kDebug() << "Name is: " << name();

    while(!atEnd()){
        readNext();

        //kDebug() << "Name is: " << name();
        if(isEndElement()) break;

        if(isStartElement()){

            if(name() == "rotation"){

                //kDebug() << "found Rotation";

                if(attributes().value("id") == "complicated"){
                    //kDebug() << "Attribute value: " << "complicated";
                }
                else if(attributes().value("id") == "anticlockwise"){
                    //kDebug() << "Attribute value: " << "anticlockwise";
                    m_rotation_type = GameInfo::ANTICLOCKWISE;
                }
                else{
                    m_rotation_type = GameInfo::CLOCKWISE;
                    //kDebug() << "Attribute value: " << "clockwise";
                    //set Cup Rotation Info - clockwise
                    for(int i = 0 ; i < m_num_rows * m_cups_per_row ; i++)
                        m_rotation_cup << GameInfo::ANTICLOCKWISE;
                }
                parseRotation();
            }

            else if( name() == "lap" ){

                //kDebug() << "found lap -----------";
                if(attributes().value("id") == "single"){
                    m_lap_style = GameInfo::SINGLE;
                    //kDebug() << "single Lap";
                }

                else if(attributes().value("id") == "multiple"){
                    //kDebug() << "lap Style:" << "multiple";
                    m_lap_style = GameInfo::MULTIPLE;
                }
                parseLap();
            }

            else if( name() == "min_stone_to_sow" )
                m_min_stones_to_sow = readElementText().toInt();

            else if( name() == "left_stone_to_cup" )
                m_left_stone_to_cup = readElementText().toInt();

            else if( name() == "omit_initial_cup" ){
                if(readElementText() == "yes")
                    m_omit_initial_cup = true;
                else m_omit_initial_cup = false;
            }

            else if( name() == "stones_to_kalah"){

                //If it is necessary that readElementText() will be used more than once then
                //assign it to a QString
                QString valueText = readElementText();
                //kDebug() << "The valueText is: " << valueText;

                if( valueText == "none")
                    m_stones_to_kalah = GameInfo::NONE;
                else if( valueText == "both" )
                    m_stones_to_kalah = GameInfo::BOTH;
                else if( valueText == "own" )
                    m_stones_to_kalah = GameInfo::OWN;
                else if( valueText == "opponent")
                    m_stones_to_kalah = GameInfo::OPPONENT;
            }
            else if(name() == "bonus_turn"){

                if(readElementText() == "yes"){
                    //kDebug() << "Bonus Turn True";
                    m_bonus_turn = true;
                }
                else m_bonus_turn = false;
            }
        }

    }
}

//capture
void GameInfo::parseCapture(){

    Q_ASSERT(isStartElement() && name() == "capture");

    //kDebug() << "I am in capture";
    while(!atEnd()){
        readNext();

        if(isEndElement()) break;


        if(isStartElement()){

            if( name() == "capture_type"){

                if(attributes().value("id") == "cross"){
                    //kDebug() << "Caputure type: cross :" << m_capture_types;
                    m_capture_types |= 1;
                    //kDebug() << "Capture types: " << m_capture_types;
                    parseCrossCapture();
                    //kDebug() << "Capture types: " << m_capture_types;
                }
                else if(attributes().value("id") == "count"){
                    m_capture_types |= 2;
                    parseCountCapture();
                }
                else if(attributes().value("id") == "series"){
                    m_capture_types |= 4;
                    parseSeriesCapture();
                }
                else if(attributes().value("id") == "pull_across"){
                    m_capture_types |= 16;
                    parsePullAcrossCapture();
                }
            }
        }
    }

}

//special rules
void GameInfo::parseSpecialRules(){

    Q_ASSERT(isStartElement() && name() == "special_rules");

    //kDebug() << "I am in special rules";

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;

        m_special_flags = 0;
        if(isStartElement()){

            if( name() == "empty_opponent" ){
                if( readElementText() == "yes")
                    m_special_flags |= 1;
                //kDebug() << "empty Opponent:" << (m_special_flags & 1);
            }
            else if( name() == "turn_passing" ){
                if(readElementText() == "yes")
                    m_special_flags |= 2;
                //kDebug() << "Turn Passing:" << (m_special_flags & 2);
            }
            else if( name() == "compulsory_move" ){
                if(readElementText() == "yes")
                    m_special_flags |= 4;
                //kDebug() << "Compulsory Moves:" << (m_special_flags & 4);
            }
        }

    }
    //kDebug() << "Special_Flags" << (m_special_flags & 1) << " " << (m_special_flags & 2) << " " << (m_special_flags & 4);
}


//end_rule
void GameInfo::parseEndRules(){

}

//lap
void GameInfo::parseLap(){

    Q_ASSERT( isStartElement() && name() == "lap");

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;

        if(isStartElement()){

            if( name() == "end_of_lap" && attributes().value("id") == "cup"){
                //kDebug() << "Found cup in end_of_lap";
                parseLapEnd();
            }
        }

    }
}

//lap_end
void GameInfo::parseLapEnd(){

    Q_ASSERT( isStartElement() && name() == "end_of_lap" );

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;

        if(isStartElement()){

            if( name() == "stone_no"){
                m_stones_to_end_lap = readElementText().toInt();
                //kDebug() << "Stone in cup to end lap: " << m_stones_to_end_lap;
            }

            else if( name() == "side"){
                QString valueText = readElementText();
                //kDebug() << "lap end side: " << valueText;

                if( valueText == "both")
                    m_side_to_end_lap = GameInfo::BOTH;
                else if( valueText == "own")
                    m_side_to_end_lap = GameInfo::OWN;
                else
                    m_side_to_end_lap = GameInfo::OPPONENT;
            }
        }
    }
}

//rotation - complicated
void GameInfo::parseRotation(){

    Q_ASSERT( isStartElement() && name() == "rotation" );

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;

        if(isStartElement()){

            if( name() == "clockwise"){

                int upper,j,lower;
                int numCup;// = readElementText().toInt();

                if(attributes().value("direction") == "left"){
                    numCup = readElementText().toInt();

                    upper = m_cups_per_row -1 ;
                    lower = 2 * m_cups_per_row -1;

                    for(j = 0 ; j < numCup ; ++j,--upper,--lower )
                        m_rotation_cup[upper] = m_rotation_cup[lower] = GameInfo::CLOCKWISE;


                }
                else{
                    numCup = readElementText().toInt();

                    upper = 0;
                    lower = m_cups_per_row;

                    for( j = 0 ; j < numCup; ++j,++upper,++lower)
                        m_rotation_cup[upper] = m_rotation_cup[lower] = GameInfo::CLOCKWISE;
                }
            }

            //            kDebug() << "All cup rotation type:";
            //            for( int i = 0 ; i < m_cups_per_row * m_num_rows ; i++ ){
            //                kDebug() << "Cup: " << i << m_rotation_cup[i];
            //            }

        }
    }
}

//capture parsings - CrossCapture
void GameInfo::parseCrossCapture(){

    Q_ASSERT( isStartElement() && name() == "capture_type");
    //kDebug() << "Now in CrossCapture:" << m_capture_types;

    Side captureSide;
    QList<int>stoneNumbers;
    QString text;
    QStringList list;

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;

        if(isStartElement()){

            text = readElementText();

            if( name() == "side"){
                //kDebug() << "In side: " << text;

                if( text == "own")
                    captureSide = GameInfo::OWN;
                else if( text == "opponent")
                    captureSide = GameInfo::OPPONENT;
                else if( text =="both")
                    captureSide = GameInfo::BOTH;
            }
            else if( name() == "myside_stone_no"){

                list = text.split(',');

                //kDebug() << "Putting to List:";
                for( int i = 0 ; i < list.size() ; i++ ){
                    //kDebug() << list[i].toInt() << " ";
                    stoneNumbers.append(list[i].toInt());
                }
            }

        }
    }

    //inserting to m_capture_info
    m_capture_info.append( qMakePair(captureSide,stoneNumbers) );
    //kDebug() << "Side:" << m_capture_info[0].first << " stoneNumbers: " << m_capture_info[0].second;

}

void GameInfo::parseCountCapture(){

    Q_ASSERT( isStartElement() && name() == "capture_type");

    //kDebug() << "I am in count capture";

    Side captureSide;
    QString text;
    QList<int>stoneNumbers;
    QStringList list;

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;
        if(isStartElement()){

            text = readElementText();

            if( name() == "side"){
                //kDebug() << "In side: " << text;

                if( text == "own")
                    captureSide = GameInfo::OWN;
                else if( text == "opponent")
                    captureSide = GameInfo::OPPONENT;
                else if( text =="both")
                    captureSide = GameInfo::BOTH;
            }
            else if( name() == "stones_in_cup"){

                list = text.split(',');

                if(list[0] == "number"){
                    stoneNumbers.append(GameInfo::NUMBER);

                    for(int i = 1 ; i < list.size() ; i++){
                        //kDebug() << list[i].toInt() << " ";
                        stoneNumbers.append(list[i].toInt());
                    }
                }
                else if(list[0] == "pattern"){

                    stoneNumbers.append(GameInfo::PATTERN);

                    if(list[1] == "even")
                        stoneNumbers.append(GameInfo::EVEN);
                    else if(list[1] == "odd")
                        stoneNumbers.append(GameInfo::ODD);
                }

            }

        }

    }

    //(side,countCaptureType(pattern or specific),stone numbers or pattern)
    m_capture_info.append( qMakePair(captureSide,stoneNumbers) );
    //kDebug() << "Side:" << m_capture_info[0].first << " stoneNumbers: " << m_capture_info[0].second;
}

void GameInfo::parseSeriesCapture(){

    Q_ASSERT( isStartElement() && name() == "capture_type");
    //kDebug() << "I am in series capture";

    Side captureSide;
    QList<int>stoneNumbers;//0-direction,1-grandslam option
    QString text;

    //kDebug() << "StoneNumbers Now: " << stoneNumbers;

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;
        if(isStartElement()){

            text = readElementText();

            if( name() == "side"){
                //kDebug() << "In side: " << text;

                if( text == "own")
                    captureSide = GameInfo::OWN;
                else if( text == "opponent")
                    captureSide = GameInfo::OPPONENT;
                else if( text =="both")
                    captureSide = GameInfo::BOTH;
            }
            else if( name() == "direction"){
                if(text == "following") //0
                    stoneNumbers.append(GameInfo::FOLLOWING);
                else if(text == "preceding") //1
                    stoneNumbers.append(GameInfo::PRECEDING);

            }
            else if( name() == "grandslam"){

                if(text == "penalty")
                    stoneNumbers.append(GameInfo::PENALTY);
                else if(text == "capture")
                    stoneNumbers.append(GameInfo::CAPTURE);
                else if(text == "no_capture")
                    stoneNumbers.append(GameInfo::NO_CAPTURE);
                else stoneNumbers.append(GameInfo::INVALID);
            }
        }

    }
    //kDebug() << "stoneNumbers Now:" << stoneNumbers;
    m_capture_info.append( qMakePair(captureSide,stoneNumbers) );
    //kDebug() << "Side:" << m_capture_info[1].first << " direction " << m_capture_info[1].second;
}


void GameInfo::parsePullAcrossCapture(){

    Q_ASSERT( isStartElement() && name() == "capture_type");

    while(!atEnd()){
        readNext();

        if(isEndElement()) break;

        if(isStartElement()){

        }
    }

}
