/*
Mancala - A Historical Board Game
Copyright (C) 2009-2010 A.H.M.Mahfuzur Rahman 65mahfuz90@gmail.com
Copyright (c) 2010 Reto Zingg g.d0b3rm4n@gmail.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GAMECONTROLLER_H
#define GAMECONTROLLER_H

#include <QPair>
#include <QList>

// #include <kxmlguiwindow.h>

#include <QSignalMapper>
#include <QThread>

#include "GameInfo.h"


class Board;
class Score;
class MoveGenerator;

class GameController : public QThread{

    Q_OBJECT
public:
    enum Side{UPPER,LOWER};
    enum Difficulty{EASY,MEDIUM,HARD};

    GameController(GameInfo*);

    void setBoardItem(Board* board);
    void initializeGameController();
    int humanKalahIndex(){ return m_humanKalah; }
    QPair< bool,QList<int> > logicalMoveController(QList<int>board,int cupIndex,bool turn);

signals:
    void signalShowScore(int,bool);   //score,whose
    void signalShowTurn(bool);
    void signalMessage(const QString);
    void signalGameOver();
    void timeout(int);
    void timeout(const QString&);
    void signalSowMaker(int index);
    void signalAfterSow(int index);
    void signalComputerMove();

    void signalNewGame(int);
    void signalRestartGame();

public slots:
    void slotMouseClicked(int);
    void slotGameOverForNewGame(int );
    void slotGameOverForRestartGame();
    void newGameEmitter(int);
    void restartGameEmitter();

    void makeHumanMove(int);
    void makeComputerMove();
    void crossCapture(const QString&);
    void countCapture(const QString&);
    void slotGameDifficulty(GameController::Difficulty difficulty);
    void sowMaker(int index);
    void sowController();
    void afterSow(int index);

private:
    QSignalMapper *signalMapper;

    int m_index;
    int m_rotationInfo;
    bool m_multipleLapDelay;

    Difficulty m_gameDifficulty;
    Board* m_board;
    GameInfo* m_gameInfo;
    Score* m_humanScore;
    Score* m_computerScore;
    Side m_humanSide;
    MoveGenerator *m_moveGenerator;

    int m_humanKalah;
    bool m_humanTurn;
    bool m_gamePaused;
    bool m_gameOver;
    bool m_physicalMoveAllowed; //Will be used to check invalid move
    int m_cupIndexClicked;

    //totalStone - first 2*cupPerRow(0,..) will be cupInfo, next 2 KalahInfo(left,right)
    QList<int> m_logicalBoard;
    QList<int> m_physicalBoard;
    QList<QPair< GameInfo::Side,QList<int> > > m_captureInfo;
    QList<int>m_humanSideCups;

    void setPhysicalBoard(QList<int> board);
    void setLogicalBoard(QList<int> board);
    QList<int> physicalBoard();
    QList<int> logicalBoard();

    void initializeBoard();
    void setHumanSideCups();

    bool isHumanCup(int index);
    bool isHumanKalah(int index);
    bool isGameOver(QList<int>& board);

    void handleCrossCapture(int,QList<int>& board);
    int handleCountNSeriesCapture(int,QList<int>& board);
    int nextIndex(int index,int seriesCaptureIndex);
    bool stoneNumberMatched(int index,int countCaptureIndex,QList<int>& board);

    void changeTurn();
    void showBoard(QList<int>&);
    void changeScore(int amount,bool human);

    bool isHumanSideEmpty(QList<int>& board);
    bool isComputerSideEmpty(QList<int>& board);
    void computerHasNoMove();
    void humanHasNoMove();
    void finalCapture(QList<int>& board);
    void sowingAnimation(int index,int multiplier);
    int singleSow(int index);

    bool physicalMoveController(int index);
    bool isEndOfLap(int index,QList<int>& board);

};


#endif // GAMECONTROLLER_H
