/*  
 *  Sounds Routines -- sounds.c
 *
 *  Copyright (C) 2009 Reto Zingg
  *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details, a copy of which may be found in
 *  the file COPYING provided in the main directory of this release.
 *
 */

#include <stdio.h>
#include "SDL.h"
#include "SDL_mixer.h"

int play_sound(Mix_Chunk *chunk){
        //Play the scratch effect
        if( Mix_PlayChannel( -1, chunk, 0 ) == -1 )
        {
                fprintf(stderr, "Unable to load sound: %s\n", 
                         SDL_GetError());
                exit(1);
        }
        else{
                return 0;
        }
}
