/*  
 *  AI Source Module -- ai.c
 *  Kevin Riggle
 *  http://cmancala.sourceforge.net
 *  $Source: /cvsroot/cmancala/mancala/src/Attic/ai.c,v $
 *  $Revision: 1.5.2.1 $
 *  $Date: 2003/12/29 05:49:52 $
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include "ai.h"
#include "mancala.h"

/* Return the computer's move. */
int aiMove(int *aiBoard, int *humanBoard) {

  int BestCapture, CapturePoints, BestMove, MoveSize, Test, i;
  
  BestCapture = CapturePoints = BestMove = MoveSize = Test = i = 0;

  /* printf("HAL: I'm thinking, Dave...\n"); */
  /* Loop through possible moves... */
  for(i=1;i<=BOARD_MAX;i++) {
    /* ...only if there is any move to make! */
    if (aiBoard[i] != 0) {
      /* Calculate position of final stone */
      Test = i - (aiBoard[i] % ((2 * BOARD_MAX)+1));
    
      /* If this move ends on my home, take it. */
      if (Test == 0)
	return i;
      /* If it doesn't but a capture does occur... */
      else if ((Test>0) && (aiBoard[Test] == 0)) {
	/* ...that's the best we've seen so far, store the info. */
	if (humanBoard[(BOARD_MAX + 1) - Test] > CapturePoints) {
	  BestCapture = i;
	  CapturePoints = humanBoard[(BOARD_MAX + 1) - Test];
	}
      }
      /* If neither happen, but this is larger than previous, record it. */
      if (aiBoard[i] > MoveSize) {
	BestMove = i;
	MoveSize = aiBoard[i];
      }
    }
  }

  /* If we have a good capture, take it. */
  if (BestCapture != 0)
    return BestCapture;
  
  /* Otherwise, move the largest concentration of stones. */
  return BestMove;

}

/*  End ai.c  */
