/*  expcomp - An ugly hack for adjusting exposure setting for the N900 camera. 
    Copyright (C) 2008-2009 David Osterberg (davost@gmail.com)
    
    Basic idea on how these things are done come from the file v4l2ctrl.c 
    in the package v4l2ucp. 

2011: changed under GPL for magnusplus such that it set the lens focus.
(Cristian Grozea)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <linux/types.h>
#include <linux/videodev.h>

int main(int argc, char **argv)
{
    const char *device = "/dev/video0";
    int fd, ev;
    struct v4l2_control c;
    
    fd = open(device, O_RDWR, 0);
    if(fd < 0) {
        fprintf(stderr, "Unable to open %s: %s\n", device, strerror(errno));
        return EXIT_FAILURE;
    }

    c.id = V4L2_CID_FOCUS_ABSOLUTE;
    ioctl(fd, VIDIOC_G_CTRL, &c);   /* finding out the current exposure setting */

    fprintf(stderr, "Previous focus tune (ticks): %d\n", c.value);

    ev = strtol(argv[1], NULL, 10); 
       	c.id = V4L2_CID_FOCUS_ABSOLUTE;
        c.value = ev;
        if(ioctl(fd, VIDIOC_S_CTRL, &c) == -1) {
            fprintf(stderr, "Failed to set control FOCUS: %s\n", strerror(errno));
        }
    
    fprintf(stderr, "Current focus tune (ticks): %d\n", c.value);

    close(fd);
    
    return EXIT_SUCCESS;
}
