#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <glib.h>
#include <mce/dbus-names.h>
#include <libosso.h>
#include <stdlib.h>
#include <assert.h>

#include "maenotify.h"
#include "marshal.h"


static void 
received_sms_cb (DBusGProxy *the_proxy, char **ex)
{
	(void) g_print("received_sms cb on %s\n",current_lock);
	if ( g_strcmp0(current_lock,"locked") == 0 ) 
		update_info();
}


static void 
dbus_handle_mce_message(DBusGProxy *object G_GNUC_UNUSED, const gchar *mode, const gchar *blah G_GNUC_UNUSED, gpointer user_data G_GNUC_UNUSED)
{
	(void) g_print ("lock change: %s\n", mode);

	current_lock = g_strdup(mode);
	
	if ( g_strcmp0(current_lock,"locked") == 0 ) 
		update_info();
}


int main ( int argc, char *argv[] )
{
	g_print("start!\n");

	GError *error = NULL;
	DBusGConnection *connection;
	DBusGConnection *sms_conn;
	DBusGProxy *proxy;
	DBusGProxy *sms_proxy;
	GMainLoop *loop = NULL;

	g_type_init ();

	connection = dbus_g_bus_get (DBUS_BUS_SYSTEM, &error);
	if (!connection) {
		g_printerr ("Failed to open connection to system bus: %s\n", error->message);
		g_clear_error (&error);
		return -1;
	} 
	
	sms_conn = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
	if ( !sms_conn ) {
		g_printerr ("Failed to open connection to session bus: %s\n", error->message);
		g_clear_error (&error);
		return -1;
	}

	if ( connection == NULL ) 
		g_print("con fails\n");

	if ( sms_conn == NULL )
		g_print("scon fails\n");
	
	proxy = dbus_g_proxy_new_for_name (connection, MCE_SERVICE, MCE_SIGNAL_PATH, MCE_SIGNAL_IF);
	if (!proxy) {
		g_print("proxy fails \n");
		return -1;
	}

	sms_proxy = dbus_g_proxy_new_for_name (sms_conn, DBUS_SERVICE_SMS, DBUS_PATH_SMS, DBUS_INTERFACE_SMS);
	if (!sms_proxy) {
		g_print("sms proxy fails \n");
		return -1;
	}

	
	cpixbuf = gdk_pixbuf_new_from_file(CALL_ICO,NULL);		
	spixbuf = gdk_pixbuf_new_from_file(SMS_ICO, NULL);

	desc = pango_font_description_new ();
	pango_font_description_set_weight (desc, PANGO_WEIGHT_BOLD);
	pango_font_description_set_absolute_size (desc, 22 * PANGO_SCALE);
	
	if ( !g_file_test ( BASE_PATH, G_FILE_TEST_IS_DIR ) )
		system("/bin/mkdir /home/user/.maenotify");

/*		
	if ( !g_file_test ( g_strdup_printf("%s/%s",BASE_PATH,BASE_IMG), G_FILE_TEST_EXISTS ) )
		system("/bin/cp /etc/hildon/theme/backgrounds/lockslider.png /home/user/.maenotify/");
*/	
	
	loop = g_main_loop_new (NULL, FALSE);
	if ( loop == NULL ) 
		g_print("loop fails\n");
	
	dbus_g_object_register_marshaller (marshal_VOID__BOXED, G_TYPE_NONE, G_TYPE_STRV, G_TYPE_INVALID);
	dbus_g_proxy_add_signal (sms_proxy, "MessagesExpunged", G_TYPE_STRV, G_TYPE_INVALID );
	dbus_g_proxy_connect_signal (sms_proxy, "MessagesExpunged", G_CALLBACK(received_sms_cb), sms_conn, NULL);
	
	dbus_g_proxy_add_signal (proxy, MCE_TKLOCK_MODE_SIG, G_TYPE_STRING , G_TYPE_INVALID);
	dbus_g_proxy_connect_signal (proxy, MCE_TKLOCK_MODE_SIG, G_CALLBACK (dbus_handle_mce_message), NULL, NULL);
	
	
	g_main_loop_run(loop);

  	dbus_g_proxy_disconnect_signal (proxy, MCE_TKLOCK_MODE_SIG, G_CALLBACK (dbus_handle_mce_message), NULL);
  	dbus_g_proxy_disconnect_signal (sms_proxy, "MessagesExpugned", G_CALLBACK(received_sms_cb), NULL);
  
	g_object_unref (proxy);
	g_object_unref (sms_proxy);
	dbus_g_connection_flush (connection);
	dbus_g_connection_unref (connection);

	return 0;

}
