TEMPLATE = app
TARGET = macuco2
SOURCES = main.cpp \
    networkcookiejar.cpp \
    mainwindow.cpp \
    gotodlg.cpp \
    bookmark.cpp \
    bookmarksdlg.cpp \
    bookmarkdlg.cpp \
    webpage.cpp \
    application.cpp

HEADERS = \
    webpage.h \
    networkcookiejar.h \
    mainwindow.h \
    fullscreenexitbutton.h \
    gotodlg.h \
    bookmark.h \
    bookmarksdlg.h \
    bookmarkdlg.h \
    qwebviewselectionsuppressor.h \
    application.h \
    waitingbutton.h

OTHER_FILES += macuco2.desktop\
    data/control \
    data/postinst \
    data/64x64/macuco2.png \
    data/40x40/macuco2.png \
    data/26x26/macuco2.png \
    data/maemo/macuco2.xpm \
    macuco2.spec \
    data/meego/macuco2.desktop \
    macuco2.yaml \
    data/debian/rules \
    data/debian/copyright \
    data/debian/control \
    data/debian/compat \
    data/debian/changelog \
    data/com.crochik.Macuco.xml \
    data/com.crochik.Macuco.service \
    data/maemo/macuco2

QT += network \
    webkit

FORMS += \
    gotodlg.ui \
    bookmarksdlg.ui \
    bookmarkdlg.ui

RESOURCES += resources.qrc

maemo5 {
    QT += dbus \
        maemo5

    HEADERS += pickselectoraction.h \
        macucodbusadptr.h
    SOURCES += pickselectoraction.cpp \
        macucodbusadptr.cpp
}

# INSTALL
unix {

    PREFIX = $$INSTALL_ROOT
    DATADIR = $$PREFIX/usr/share
    DEFINES += DATADIR=\"$$DATADIR\"

    INSTALLS += target \
        desktop \
        icon64

    #MAEMO
    maemo5 {
	BINDIR = $$PREFIX/opt/crochik
	target.path = $$BINDIR

	INSTALLS += icon26 \
	    icon40 \
	    service \
	    script

	desktop.path = $$DATADIR/applications/hildon
	desktop.files += macuco2.desktop

	icon26.path = $$DATADIR/icons/hicolor/26x26/apps
	icon26.files += data/26x26/macuco2.png

	icon40.path = $$DATADIR/icons/hicolor/40x40/apps
	icon40.files += data/40x40/macuco2.png

	icon64.path = $$DATADIR/icons/hicolor/64x64/apps
	icon64.files += data/64x64/macuco2.png

        # service
        service.path = $$PREFIX/usr/share/dbus-1/services
        service.files = data/com.crochik.Macuco.service

        # sh script
        script.path = $$INSTALL_ROOT/usr/bin
        script.files += data/maemo/macuco2
    }

    # MEEGO
    !maemo5 {
	BINDIR = $$PREFIX/usr/bin
	target.path = $$BINDIR

	desktop.path = $$DATADIR/applications
	desktop.files += data/meego/macuco2.desktop

	icon64.path = $$DATADIR/pixmaps
	icon64.files += data/64x64/macuco2.png
    }
}
