#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QtCore/QCoreApplication>
#include <QtGui>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    connect(QApplication::desktop(),SIGNAL(resized(int)),this,SLOT(reorderUI()));
}

void MainWindow::reorderUI(){
#ifdef Q_WS_MAEMO_5
    /*if (Qt::WA_Maemo5PortraitOrientation==QApplication){
        ui->GetKey->setText("");
    }*/
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
             if (screenGeometry.width() > screenGeometry.height()){
                 //Landscape Mode
                 ui->btnClear->setGeometry(410,305,246,110);
                 ui->btnGetOrg->setGeometry(535,305,246,110);
                 ui->btnBack->setGeometry(230,305,180,110);
                 ui->formLayoutWidget_2->setGeometry(205,15,576,56);
                 ui->btn_0->setGeometry(10,85,110,110);
                 ui->btn_1->setGeometry(120,85,110,110);
                 ui->btn_2->setGeometry(230,85,110,110);
                 ui->btn_3->setGeometry(340,85,110,110);
                 ui->btn_4->setGeometry(450,85,110,110);
                 ui->btn_5->setGeometry(560,85,110,110);
                 ui->btn_6->setGeometry(670,85,110,110);
                 ui->btn_7->setGeometry(10,195,110,110);
                 ui->btn_8->setGeometry(120,195,110,110);
                 ui->btn_9->setGeometry(230,195,110,110);
                 ui->btn_A->setGeometry(340,195,110,110);
                 ui->btn_B->setGeometry(450,195,110,110);
                 ui->btn_C->setGeometry(560,195,110,110);
                 ui->btn_D->setGeometry(670,195,110,110);
                 ui->btn_E->setGeometry(10,305,110,110);
                 ui->btn_F->setGeometry(120,305,110,110);



             }
             else{
                 //Portrait Mode
                 ui->btnClear->setGeometry(360,10,105,110);
                 ui->btnGetOrg->setGeometry(10,560,270,110);
                 ui->btnBack->setGeometry(285,560,180,110);
                 ui->formLayoutWidget_2->setGeometry(10,60,350,56);
                 ui->btn_0->setGeometry(10,120,110,110);
                 ui->btn_1->setGeometry(125,120,110,110);
                 ui->btn_2->setGeometry(240,120,110,110);
                 ui->btn_3->setGeometry(355,120,110,110);
                 ui->btn_4->setGeometry(10,230,110,110);
                 ui->btn_5->setGeometry(125,230,110,110);
                 ui->btn_6->setGeometry(240,230,110,110);
                 ui->btn_7->setGeometry(355,230,110,110);
                 ui->btn_8->setGeometry(10,340,110,110);
                 ui->btn_9->setGeometry(125,340,110,110);
                 ui->btn_A->setGeometry(240,340,110,110);
                 ui->btn_B->setGeometry(355,340,110,110);
                 ui->btn_C->setGeometry(10,450,110,110);
                 ui->btn_D->setGeometry(125,450,110,110);
                 ui->btn_E->setGeometry(240,450,110,110);
                 ui->btn_F->setGeometry(355,450,110,110);
                 }
#endif
}

void MainWindow::on_btn_0_pressed()
{
     insertChar(QString('0'));
}

void MainWindow::on_btn_1_pressed()
{
     insertChar(QString('1'));
}

void MainWindow::on_btn_2_pressed()
{
     insertChar(QString('2'));
}

void MainWindow::on_btn_3_pressed()
{
     insertChar(QString('3'));
}

void MainWindow::on_btn_4_pressed()
{
     insertChar(QString('4'));
}

void MainWindow::on_btn_5_pressed()
{
     insertChar(QString('5'));
}

void MainWindow::on_btn_6_pressed()
{
     insertChar(QString('6'));
}

void MainWindow::on_btn_7_pressed()
{
     insertChar(QString('7'));
}

void MainWindow::on_btn_8_pressed()
{
     insertChar(QString('8'));
}

void MainWindow::on_btn_9_pressed()
{
     insertChar(QString('9'));
}

void MainWindow::on_btn_A_pressed()
{
     insertChar(QString('A'));
}

void MainWindow::on_btn_B_pressed()
{
     insertChar(QString('B'));
}

void MainWindow::on_btn_C_pressed()
{
   insertChar(QString('C'));
}

void MainWindow::on_btn_D_pressed()
{
     insertChar(QString('D'));
}

void MainWindow::on_btn_E_pressed()
{
    insertChar(QString('E'));
}

void MainWindow::on_btn_F_pressed()
{
    insertChar(QString('F'));
}

void MainWindow::on_btnClear_pressed()
{
    ui->edtOUI->clear();
    ui->edtOrg->clear();
}

void MainWindow::on_btnBack_pressed()
{
    QString mac = ui->edtOUI->text();
    if (mac.count()>6){
        ui->edtOUI->setText(mac.left(mac.count()-1));
    }else if (mac.count()>4){
        ui->edtOUI->setText(mac.left(mac.count()-2));
    }else{
        ui->edtOUI->setText(mac.left(mac.count()-3));
    }
}

void MainWindow::insertChar(QString character){
    QString mac = ui->edtOUI->text();
    if (mac.count()>6){
        ui->edtOUI->setText(mac.insert(mac.count(),character));
    }else if (mac.count()>4){
        ui->edtOUI->setText(mac.insert(mac.count()-1,character));
    }else{
        ui->edtOUI->setText(mac.insert(mac.count()-2,character));
    }
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::setOrientation(ScreenOrientation orientation){  
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702

    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded(){
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}

void MainWindow::on_btnGetOrg_pressed()
{
    if (ui->edtOUI->text().simplified().count()>2){
        ui->edtOrg->setText("");
        QFile *file=new QFile(":/oui");
             if (file->open(QIODevice::ReadOnly | QIODevice::Text)){
                QTextStream *t= new QTextStream(file);
                int i=0;
                QString line;
                while ( !t->atEnd() ) {
                    i++;
                    line=t->readLine();
                    if (line.indexOf(ui->edtOUI->text().replace(":","-"))!=-1){
                        ui->edtOrg->setText(line.mid(line.indexOf("(hex)")+5).simplified());
                        break;
                    }
		    if (i==15380){
                        ui->edtOrg->setText("Not found");
                    }
                    //listaNombres->append(t->readLine());
                }
                file->close();
                delete t;
            }
            delete file;
    }else{
        ui->edtOrg->setText("Please fill the OUI first");
    }
}
