/*
 * tangle-droppable-actor.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_DROPPABLE_ACTOR_H__
#define __TANGLE_DROPPABLE_ACTOR_H__

#include "tangle-wrapper-actor.h"

#define TANGLE_TYPE_DROPPABLE_ACTOR (tangle_droppable_actor_get_type())
#define TANGLE_DROPPABLE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_DROPPABLE_ACTOR, TangleDroppableActor))
#define TANGLE_IS_DROPPABLE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_DROPPABLE_ACTOR))
#define TANGLE_DROPPABLE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_DROPPABLE_ACTOR, TangleDroppableActorClass))
#define TANGLE_IS_DROPPABLE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_DROPPABLE_ACTOR))
#define TANGLE_DROPPABLE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_DROPPABLE_ACTOR, TangleDroppableActorClass))

typedef struct _TangleDroppableActorPrivate TangleDroppableActorPrivate;
typedef struct _TangleDroppableActorClass TangleDroppableActorClass;

typedef struct _TangleDroppableActor {
	TangleWrapperActor parent_instance;
	TangleDroppableActorPrivate* priv;
} TangleDroppableActor;

#include "tangle-draggable-actor.h"

struct _TangleDroppableActorClass {
	TangleWrapperActorClass parent_class;
	
	gboolean (*is_dragging_droppable)(TangleDroppableActor* droppable_actor, TangleDragging* dragging);
	gboolean (*handle_dragging)(TangleDroppableActor* droppable_actor, TangleDragging* dragging);
	gboolean (*handle_dropping)(TangleDroppableActor* droppable_actor, TangleDragging* dragging, gboolean accepted);	
};

GType tangle_droppable_actor_get_type(void) G_GNUC_CONST;

ClutterActor* tangle_droppable_actor_new(ClutterActor* wrapped);

gboolean tangle_droppable_actor_is_dragging_droppable(TangleDroppableActor* droppable_actor, TangleDragging* dragging);
void tangle_droppable_actor_handle_dragging(TangleDroppableActor* droppable_actor, TangleDragging* dragging);
void tangle_droppable_actor_handle_dropping(TangleDroppableActor* droppable_actor, TangleDragging* dragging, gboolean accepted);

#endif
