//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qmaemo5informationbox_c.h"

#if defined MAEMO5
QMaemo5InformationBoxH QMaemo5InformationBox_create(QWidgetH parent)
{
	return (QMaemo5InformationBoxH) new QMaemo5InformationBox((QWidget*)parent);
}

void QMaemo5InformationBox_destroy(QMaemo5InformationBoxH handle)
{
	delete (QMaemo5InformationBox *)handle;
}

void QMaemo5InformationBox_setWidget(QMaemo5InformationBoxH handle, QWidgetH widget)
{
	((QMaemo5InformationBox *)handle)->setWidget((QWidget*)widget);
}

QWidgetH QMaemo5InformationBox_widget(QMaemo5InformationBoxH handle)
{
	return (QWidgetH) ((QMaemo5InformationBox *)handle)->widget();
}

void QMaemo5InformationBox_setTimeout(QMaemo5InformationBoxH handle, int ms)
{
	((QMaemo5InformationBox *)handle)->setTimeout(ms);
}

int QMaemo5InformationBox_timeout(QMaemo5InformationBoxH handle)
{
	return (int) ((QMaemo5InformationBox *)handle)->timeout();
}

void QMaemo5InformationBox_information(QWidgetH parent, PWideString text, int timeout)
{
	QString t_text;
	copyPWideStringToQString(text, t_text);
	QMaemo5InformationBox::information((QWidget*)parent, t_text, timeout);
}

#endif
