# coding: latin-1
CONSUMER_KEY = 'HAx8kcrVi8z6jsPxPSMrWA'
USER_AGENT = 'Firefox/3.5 Maemo Browser 1.5.6 RX-51 N900'
QYPE_URL = 'http://api.qype.com/v1/'
QYPE_MOBILE = 'http://m.qype.co.uk/mobile/places/'
MEDIA_PATH = '/usr/share/libellule/'

import libellule.provider as provider
from lxml import etree
import gtk
import os

class Qype(provider.Provider):

    def __init__(self):
        provider.Provider.__init__(self)
        self.categories_cache = {}
        self.browse_categories = True
        self.search = False

    def get(self, data=None, params=None):

        #top category
        if not data:
            return self.get_categories()
        #places
        elif data.isdigit():
            parameters = {'category' : data,
                          'consumer_key' : CONSUMER_KEY}
            if params:
                parameters.update(params)
            return self.get_places(parameters)
        #places, selected page
        elif '/places?' in data:
            return self.get_places(url=data)
        else:
            return self.get_categories(data)


    def get_categories(self, url=None):
        """Return subcategories in the specified category id
        id : category id"""

        if not url:
            url = 'http://api.qype.com/v1/place_categories'

        params = {'consumer_key' : CONSUMER_KEY}

        xml_data = self.retrieve_data(url, params)
        xml_data = xml_data[xml_data.find('<?xml version='):]
    
        categories = provider.CategoriesList()
        root = etree.XML(xml_data)

        #Add link to category places, except if top
        if url != 'http://api.qype.com/v1/place_categories':
            print self.categories_cache
            print url[40:-9]
            title = "<b>" + self.categories_cache[url[40:-9]] + "</b>"
            categories.add(title, 
                                    url[40:-9])
        for category in root.iter('category'):
            id = category.find('id').text.split('/')[-1]
            self.categories_cache.update({id : category.find('title').text})
            children_link = None
            for link in category.findall('link'):
                if link.get("rel") == 'http://schemas.qype.com/place_categories.children':
                    children_link = link.get('href')
            if children_link:
                categories.add(category.find('title').text, children_link)
            else:
                categories.add(category.find('title').text, id)

        return categories


    def get_places(self, parameters=None, url=None):
        print parameters
        if not url:
            url = "%spositions/%s,%s/places" % (QYPE_URL, 
                                                parameters['latitude'], 
                                                parameters['longitude'])
            http_params = {'in_category' : parameters['category'],
                           'consumer_key' : CONSUMER_KEY}
        else:
            http_params = []
        xml_data = self.retrieve_data(url, http_params)
        xml_data = xml_data[xml_data.find('<?xml version='):]
        places = provider.PlacesList()
        root = etree.XML(xml_data)    
        #Parse navigation links
        for nav_link in root.iter('link'):
            if nav_link.get("rel") == 'first':
                places.first_page = nav_link.get('href')
            if nav_link.get("rel") == 'previous':
                places.previous_page = nav_link.get('href')
            if nav_link.get("rel") == 'next':
                places.next_page = nav_link.get('href')
            if nav_link.get("rel") == 'last':
                places.last_page = nav_link.get('href')
        self.places_cache = {}
        for place in root.iter('place'):
            distance = place.findtext('distance')[0:-13]
            places.add({'title' : place.find('title').text, 
                            'url' : place.findtext('url'), 
                            'id' : place.find('id').text, 
                            'hours' : place.findtext('opening_hours'), 
                            'phone' : place.findtext('phone'), 
                            'rating' : place.findtext('average_rating'), 
                            'distance' : distance, 
                            'postcode' : place.find('address').findtext('postcode'), 
                            'city' : place.find('address').findtext('city'), 
                            'housenumber' : place.find('address').findtext('housenumber'), 
                            'street' : place.find('address').findtext('street'), 
                            'latitude' : place.findtext('point').split(',')[0],
                            'longitude' : place.findtext('point').split(',')[1], 
                            'stars_img' : rating_to_starimg(place.findtext('average_rating'))})
                            
            self.places_cache.update({place.find('id').text : {
                            'title' : place.find('title').text, 
                            'url' : place.findtext('url'), 
                            'id' : place.find('id').text, 
                            'hours' : place.findtext('opening_hours'), 
                            'phone' : place.findtext('phone'), 
                            'rating' : place.findtext('average_rating'), 
                            'distance' : distance, 
                            'postcode' : place.find('address').findtext('postcode'), 
                            'city' : place.find('address').findtext('city'), 
                            'housenumber' : place.find('address').findtext('housenumber'), 
                            'street' : place.find('address').findtext('street'), 
                            'latitude' : place.findtext('point').split(',')[0],
                            'longitude' : place.findtext('point').split(',')[1], 
                            'stars_img' : rating_to_starimg(place.findtext('average_rating'))}})

        print places.get_list()
        return places


    def get_place(self, id):
        place = Place()
        place.data = self.places_cache[id]
        return place


class Place():
    def __init__(self):
        self.data = {}

    def phone(self):
        return self.data['phone']

    def get_table(self):
        table = gtk.Table(5,  2)        
        label = gtk.Label("Distance : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  0,  1,  gtk.SHRINK)
        label = gtk.Label("Address : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  1,  2,  gtk.SHRINK)
        label = gtk.Label("Phone : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  2,  3,  gtk.SHRINK)
        label = gtk.Label("Opening hours : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  3,  4,  gtk.SHRINK)
        
        distance = "%s km" % self.data['distance']
        label = gtk.Label(distance)
        label.set_alignment(0,  0)
        label.set_padding(0,  10)        
        table.attach(label, 1, 2,  0,  1)
        label = gtk.Label(self.get_address())
        label.set_alignment(0,  0)
        label.set_padding(0,  10)       
        table.attach(label, 1,  2,  1,  2)
        label = gtk.Label(self.data['phone'])
        label.set_alignment(0,  0)
        label.set_padding(0,  10)       
        table.attach(label,  1,  2,  2,  3)
        label = gtk.Label(self.data['hours'])
        label.set_alignment(0,  0)
        label.set_padding(0,  10)       
        table.attach(label, 1,  2,  3,  4)

        return table

    def get_address(self):
        address = ''
        if self.data['housenumber']: address = self.data['housenumber'] + " "
        if self.data['street']: address = address + self.data['street'] + "\n"
        if self.data['postcode']: address = address + self.data['postcode'] + " " + self.data['city']
        return address

    def get_phone(self):
        if self.data['phone']:
            return self.data['phone'].replace(' ', '').replace('-', '')

    def get_title(self):
        return self.data['title']

    def get_rating(self):
        return int(self.data['rating'])

    def get_coord(self):
        return (self.data['latitude'], self.data['longitude'])

    def get_privatelink(self):
        id = self.data['id'].split('/')[-1]
        current_path = os.path.dirname( os.path.realpath( __file__ ) )
        logo = gtk.image_new_from_file(MEDIA_PATH + 'qype_icon.png')
        return logo, QYPE_MOBILE + id

    def get_astext(self):
        text = "Title : " + self.data['title'] + "\n"
        text = text + "Address : " + self.get_address() + "\n"
        if self.data['phone']:
            text = text + "Phone : " + self.data['phone'] + "\n"
        text = text + "link : " + QYPE_MOBILE + self.data['id'].split('/')[-1] + "\n"
        return text
        
    def get_starimg(self):
        return self.data['stars_img']
        
    def get_hbox_title(self):
        hbox = gtk.HBox(False, 0)
        label = gtk.Label()
        label.set_markup("<b>" + self.data['title'] + "</b>")
        hbox.pack_start(label, True, True, 0)
        hbox_star = gtk.HBox(False, 0)
        hbox_star.pack_start(gtk.image_new_from_pixbuf(self.get_starimg()),
                             False)
        hbox.pack_start(hbox_star,  False, False,   50);
        return hbox


def rating_to_starimg(rating):
    img = MEDIA_PATH + "star_%s.png" % rating
    return gtk.gdk.pixbuf_new_from_file(img)
    

if __name__ == "__main__":
    pv = Qype()
    #print pv.get().get()
    #print pv.get('http://api.qype.com/v1/place_categories/4/children').get_list()
    print pv.get('507', {'latitude' : 48.769065, 'longitude' : 2.027348}).get_list()



