"""Master provider class
Provides common function for custom providers"""

import urllib
import urllib2


USER_AGENT = 'Firefox/3.5 Maemo Browser 1.5.6 RX-51 N900'

class Provider():
    """Master provider class
    Provides common function for custom providers"""
    
    def __init__(self):
        pass


    def retrieve_data(self, url, parameters=None, header=None):
        """Retrieve the specified url
        url : url to retrieve
        parameters : query parameters"""
        if parameters:
            url = url + '?' + urllib.urlencode(parameters)
        print url
        headers = {'User-Agent' : USER_AGENT,}
        if header:
            headers.update(header)
        req = urllib2.Request(url,  None,  headers)
        data = urllib2.urlopen(req).read()
        return data
        

class CategoriesList():
    """Categories list class
    Used to return result of categories to the application
    data contains the result list
    title : category title"""
    
    def __init__(self):
        self.categories = []

    def add(self, title, id):
        self.categories.append({'title' : title, 
                         'id' : id,})
    def get_list(self):
        return self.categories

    def __iter__(self):
        for categorie in self.categories:
            yield categorie

    def __getitem__(self, i):
        return self.categories[i]
         
    def __len__(self):
        return len(self.categories)


class PlacesList():
    """Places list class
    Used to return result of places to the application"""

    def __init__(self):
        self.places = []
        self.first_page = None
        self.last_page = None
        self.next_page = None
        self.previous_page = None

    def add(self, item):
        self.places.append(item)

    def get_list(self):
        return self.places

    def __iter__(self):
        for place in self.places:
            yield place

    def __getitem__(self, i):
        return self.places[i]

    def __len__(self):
        return len(self.places)



