/*
  Load applet - Maemo5 edition

*/

#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <glib/gerror.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <string.h>
#include <osso-log.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <dbus/dbus.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <sched.h>
#include "item.h"

#define LOAD_APPLET_STATUS_MENU_ITEM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, LOAD_APPLET_TYPE_STATUS_MENU_ITEM, LoadAppletStatusMenuItemPrivate))

struct _LoadAppletStatusMenuItemPrivate {
	GtkWidget *buttonStatus; 
	GtkWidget *buttonPicture;
	GtkWidget *buttonVideo;
	GtkWidget *buttonSettings;
	GtkWidget *icon;
	gulong screenshot_h;
	gulong video_h;
	pid_t rec_pid;
	gboolean recording;

	DBusError error;
	GMainLoop *loop;
	DBusConnection *conn;
	guint timeout;

};

HD_DEFINE_PLUGIN_MODULE (LoadAppletStatusMenuItem, load_applet_status_menu_item, HD_TYPE_STATUS_MENU_ITEM)



#define SHUTTER_SOUND "/usr/share/sounds/camera_snd_title_1.wav"
#define BEEP_SOUND    "/usr/share/sounds/ui-default_beep.wav" 
#define MAX_SSHOT_NAME_LEN 64
static gchar *sshotfilename = NULL;
static char sshotname[MAX_SSHOT_NAME_LEN];
static guint screenshot_delay = 20;
static guint beeps = 0;
static gint sshotn = 0;
static gint scastn = 0;
static gboolean taking = FALSE;

#define MATCH_CAMERA_KEY "type='signal',"   	  \
        "interface='org.freedesktop.Hal.Device'," 


static void
load_applet_status_menu_item_class_finalize(LoadAppletStatusMenuItemClass * klass)
{
}

static void
load_applet_status_menu_item_dispose(GObject * object)
{
	G_OBJECT_CLASS(load_applet_status_menu_item_parent_class)->dispose(object);
}

static void
load_applet_status_menu_item_class_init(LoadAppletStatusMenuItemClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS(klass);

	object_class->dispose = load_applet_status_menu_item_dispose;

	g_type_class_add_private(klass, sizeof(LoadAppletStatusMenuItemPrivate));
}

/*
 * Get the filename for next screen-shot. Start with nr.
 * 
 */
static int
get_next_sshot(gint nr, const gchar *suffix)
{
	FILE *f;
	gint n;

	n = nr;
	f = NULL;
	do {
		g_snprintf (sshotname, MAX_SSHOT_NAME_LEN-1, "%s/MyDocs/.images/%s%02d.%s", getenv("HOME"), sshotfilename, n, suffix);
		f = g_fopen(sshotname, "r");
		if (f) {
			fclose(f); 
			n++;
		}
	}
	while(f != NULL);
		
	return n;
}


/*
 * Get the filename for next screen-cast. Start with nr.
 * 
 */
static int
get_next_scast(gint nr, const gchar *suffix)
{
	FILE *f;
	gint n;

	n = nr;
	f = NULL;
	do {
		g_snprintf (sshotname, MAX_SSHOT_NAME_LEN-1, "%s/MyDocs/.videos/%s%02d.%s", getenv("HOME"), "screencast", n, suffix);
		f = g_fopen(sshotname, "r");
		if (f) {
			fclose(f); 
			n++;
		}
	}
	while(f != NULL);
		
	return n;
}



/*
 * Close the menu, make sure it is closed and redrawn
 */
static void
do_little_dance (void)
{
	while (gtk_events_pending())
	{
		gtk_main_iteration();
	}

	usleep(1000);
	sched_yield();
}


/*
 *  Take screeshot using the root window drawable
 */
static gboolean
take_screenshot(void)
{
	int width, height;
	GdkDrawable *root_window;
	GdkPixbuf *pixbuf;
	gboolean ret;
	GError *error = NULL;
	
	do_little_dance();
	sshotn = get_next_sshot(sshotn, "png");


	root_window = gdk_get_default_root_window();
	gdk_drawable_get_size(root_window, &width, &height);
	pixbuf = gdk_pixbuf_get_from_drawable(NULL,
                                           root_window,
                                           gdk_drawable_get_colormap (root_window),
                                           0, 0,
                                           0, 0,
                                           width, height);
      

	ret = gdk_pixbuf_save(pixbuf, sshotname, "png", &error, NULL);
	g_object_unref(pixbuf);

	//DEBUG
	//printf("\tSaving %s\n", sshotname);

	return FALSE;
}


/*
 * Either beep or play shutter sound and make the screenshot
 */
static gboolean
beep_or_shoot(gpointer data)
{
	beeps++;
	if (beeps >= screenshot_delay) {
		hildon_play_system_sound(SHUTTER_SOUND);
		take_screenshot();
		return FALSE; 
	} else {
		hildon_play_system_sound(BEEP_SOUND);
		return TRUE;  
	}
}


static DBusHandlerResult
handle_dbus_events(DBusConnection *connection, DBusMessage *msg, void *user_data)
{
	if (taking == FALSE) 
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;

	gint message_type = -1;
	const gchar *interface = dbus_message_get_interface(msg);
        const gchar *method = dbus_message_get_member(msg);
	LoadAppletStatusMenuItem *item = (LoadAppletStatusMenuItem*)user_data;
	item->priv = LOAD_APPLET_STATUS_MENU_ITEM_GET_PRIVATE (item);

	if (!(message_type = dbus_message_get_type(msg)) || !interface || !method) 
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;

	switch (message_type) {
	case DBUS_MESSAGE_TYPE_SIGNAL:
		if ((g_strcmp0(interface, "org.freedesktop.Hal.Device") == 0) &&
                    (g_strcmp0(method, "PropertyModified") == 0)) {
			//Camera key pressed. Take screenshot, cancel the waiting loop, remove D-Bus listener
			gtk_timeout_remove(item->priv->timeout);
			taking = FALSE;
			hildon_play_system_sound(SHUTTER_SOUND);
			take_screenshot();
			dbus_bus_remove_match(item->priv->conn, MATCH_CAMERA_KEY, &item->priv->error);
			dbus_connection_unref(item->priv->conn);
			item->priv->conn = 0;
			g_main_loop_unref(item->priv->loop);
			item->priv->loop = NULL;
		}
		break;
	default:
		break;
	}
	return DBUS_HANDLER_RESULT_HANDLED;
}




/*
 * Answer the callback by setting delayed screenshot
 */
static void
activate_delayed_screenshot_item(GtkMenuItem *item, gpointer data)
{
	LoadAppletStatusMenuItem *menu_item = (LoadAppletStatusMenuItem*)data;
	menu_item->priv = LOAD_APPLET_STATUS_MENU_ITEM_GET_PRIVATE (menu_item);

	hildon_banner_show_information(NULL, NULL, "You have 20s to press the camera capture key to take screenshot.");
	beeps = 0;
	taking = TRUE;
	menu_item->priv->timeout = gtk_timeout_add(1000, beep_or_shoot, NULL);

	menu_item->priv->loop = g_main_loop_new(NULL, FALSE);
	dbus_error_init(&menu_item->priv->error);
	if ((menu_item->priv->conn = dbus_bus_get(DBUS_BUS_SYSTEM, &menu_item->priv->error)) == NULL) {
		DLOG_CRIT("LA:Failed to open connection to system bus");
                dbus_error_free(&menu_item->priv->error);
                return;
        }
	if (!dbus_connection_add_filter(menu_item->priv->conn, handle_dbus_events, (void *)data, 0)) {
                ULOG_CRIT("LA:Failed to add dbus filter");
                dbus_error_free(&menu_item->priv->error);
                return;
        }
	dbus_bus_add_match(menu_item->priv->conn, MATCH_CAMERA_KEY, &menu_item->priv->error);
        if (dbus_error_is_set(&menu_item->priv->error)) {
                ULOG_WARN("LA:Unable to add match for my key");
                dbus_error_free(&menu_item->priv->error);
        }
	dbus_connection_setup_with_g_main(menu_item->priv->conn, NULL);
}


/*
 * Answer the callback on video button
 * If idle, start recording
 * If already recording, stop
 */
static void
activate_video_item(GtkMenuItem *item, gpointer data)
{	
	LoadAppletStatusMenuItem *la_item = (LoadAppletStatusMenuItem*)data;
	pid_t rec_pid;
	gchar *savefile;
		
	if (la_item->priv->recording == FALSE) {
		// We are not recording. Start recording by exec
		scastn = get_next_scast(scastn, "avi");
		savefile = g_strdup_printf("location=%s", sshotname);
		rec_pid = fork();
		if (rec_pid == 0) {
			execl("/usr/bin/gst-launch", "/usr/bin/gst-launch", "ximagesrc", "!", "video/x-raw-rgb,framerate=5/1", "!", "ffmpegcolorspace", "!", "jpegenc", "quality=50", "!", "queue", "!", "mux.", "autoaudiosrc", "!", "audioconvert", "!", "audioresample", "!", "queue", "!", "mux.", "avimux", "name=mux", "!", "filesink", savefile, NULL); 
			exit(0);
		} else {
			la_item->priv->recording = TRUE;
			la_item->priv->rec_pid = rec_pid;
		}
	} else {
		// We are already recording	
		kill(la_item->priv->rec_pid, SIGTERM);
		la_item->priv->recording = FALSE;
	}
}




static void
load_applet_status_menu_item_init (LoadAppletStatusMenuItem * menu_item)
{
	#define ICON_DIR        "/usr/share/pixmaps/"
	#define ICON_VIDEO      ICON_DIR"la_video.png"
	#define ICON_PICTURE    ICON_DIR"la_picture.png"

	GtkWidget *hbox, *icon;

	menu_item->priv = LOAD_APPLET_STATUS_MENU_ITEM_GET_PRIVATE (menu_item);

	hbox = gtk_hbox_new(FALSE, 0);

	//Load stuff
	sshotfilename = g_strdup("screenshot");

	// Button Video
	menu_item->priv->buttonVideo = gtk_toggle_button_new();
	gtk_widget_show(menu_item->priv->buttonVideo);
	icon = gtk_image_new_from_file(ICON_VIDEO);
	gtk_widget_show(icon);
	gtk_button_set_image(GTK_BUTTON(menu_item->priv->buttonVideo), GTK_WIDGET(icon));
	gtk_box_pack_start(GTK_BOX(hbox), menu_item->priv->buttonVideo, TRUE, TRUE, 1);
	menu_item->priv->screenshot_h = g_signal_connect(menu_item->priv->buttonVideo, "clicked", G_CALLBACK(activate_video_item), menu_item);
	// Button Picture
	menu_item->priv->buttonPicture = gtk_button_new();
	gtk_widget_show(menu_item->priv->buttonPicture);
	icon = gtk_image_new_from_file(ICON_PICTURE);
	gtk_widget_show(icon);
	gtk_button_set_image(GTK_BUTTON(menu_item->priv->buttonPicture), GTK_WIDGET(icon));
	gtk_box_pack_start(GTK_BOX(hbox), menu_item->priv->buttonPicture, TRUE, TRUE, 1);  
	menu_item->priv->screenshot_h = g_signal_connect(menu_item->priv->buttonPicture, "clicked", G_CALLBACK(activate_delayed_screenshot_item), menu_item);

	// Pack widgets to menu
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(menu_item), hbox);
	gtk_widget_show(GTK_WIDGET(menu_item));
	
	// More init
	menu_item->priv->recording = FALSE;



}



