/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/
import QtQuick 1.0

Item {
    id:menubutton
    property string  text
    property string  tip
    property bool  selected

    signal clicked

    Rectangle{
        id:menurectangle
        color: selected ? "#000000":"#a7bfe8"
        anchors.fill:parent
        radius: 8
        border.color: "#ca8282"

        Text {
            id: text1
            x: 20
            y: 8
            text:menubutton.text
            font.bold: true
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 22
            color:"#404040"
        }

        Text {
            id: text2
            x: 20
            y: 33
            text:menubutton.tip
            font.bold: true
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 16
            color:"grey"
        }
    }

    MouseArea {
        id: mouseRegion
        anchors.fill: menurectangle
        onClicked: { menubutton.clicked(); }
    }

    states: [
        State {
            name: "Pressed"
            when: mouseRegion.pressed == true
            PropertyChanges { target: menurectangle; color:"white" }
        }
    ]
}
