import QtQuick 1.0

Item {
    property string buttonName: "NOT SET"
    property string target: "NOT SET"
    property string text: "NOT SET"

    property string fontName: "Helvetica"
    property int fontSize: 14
    property color fontColor: "black"

    property bool active: false

    signal clicked(string target, string button)

    width: 140
    height: 60
    opacity: enabled ? 1.0 : 0.5

    Rectangle{
        anchors.fill: parent
        width: container.width
        height: container.height
        color:"white"
        border.color: "black"
        radius: 8
    }

    Text {
        id: buttonLabel
        text: parent.text
        wrapMode: Text.WordWrap

        anchors {
            horizontalCenter: parent.horizontalCenter
            verticalCenter: parent.verticalCenter
        }
        font {
            family: container.fontName
            pointSize: container.fontSize
        }
        color: container.fontColor
    }
}
