/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

Item {

    id:title_bar

    height: 46
    width: parent.width

    opacity: 0.8

    /*
      Default value of properties
      */

    property int radius: 4
    property string border_color: "#e28282"
    property string background_color: "white"

    property int shadow_height: 10
    property string shadow_begin_color: "#000000"
    property string shadow_end_color: "#fff7f7"

    property string caption: ""
    property string caption_color: "black"
    property string caption_font: "Tahoma"
    property int caption_font_size: 18
    property bool caption_font_bold : true

    /*
      Signals
      */

    signal minimize
    signal close

    /*
      Title Bar Init
      */

    Rectangle {
        id:main_title

        width: parent.width
        height: parent.height

        color: parent.background_color
        radius: parent.radius
        border.color: parent.border_color
    }

    Text {
        id:title_bar_caption

        text: parent.caption

        font.bold: parent.caption_font_bold
        font.pointSize: parent.caption_font_size
        font.family: parent.caption_font

        color: parent.caption_color

        x:btn_minimize.width + 5*2
        y:(main_title.height/2) - (height/2)
    }

    /*
      Title Bar Buttons
      */

    /*
      Minimize button
      */

    Rectangle {
        id: btn_minimize

        x:title_bar.x + 5
        y:title_bar.y + 5

        height: title_bar.height - 10
        width: 45

        color: "transparent"

        border.color: "grey"
        border.width: 1

        radius: parent.radius

        Rectangle {
            x:parent.x
            y:parent.y

            width: parent.width - 15
            height: parent.height - 15

            border.color: "white"
            color: "black"
            border.width: 1
        }

        Rectangle {
            x:parent.x + 5
            y:parent.y + 5
            width: parent.width - 15
            height: parent.height - 15

            border.color: "white"
            color: "black"
            border.width: 1
        }

        MouseArea {
            anchors.fill: parent

            onClicked: title_bar.minimize()

            onPressed: {
                parent.color = "blue"
            }

            onReleased: {
                parent.color = "transparent"
            }
        }

    }

    /*
      Close button
      */

    Rectangle {
        id: btn_close

        x:title_bar.width - 50
        y:title_bar.y + 5

        width: 45
        height: title_bar.height - 10

        color: "transparent"

        border.color: "grey"
        border.width: 1

        radius: parent.radius

        Text {
            id: button1
            color: "#000000"
            anchors.centerIn: parent; font.bold: true
            text: "X"; style: Text.Raised; styleColor: "black"
            font.pixelSize: 26
            font.family: "Tahoma"
        }

        MouseArea {
            anchors.fill: parent

            onClicked: title_bar.close()

            onPressed: {
                parent.color = "blue"
            }

            onReleased: {
                parent.color = "transparent"
            }
        }
    }

}
