/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

import "Themes.js" as Themes

Item {
    id: container

    Loader {
        id: theme_manager
        property alias theme: theme_manager.item
        source: Themes.default_theme()
    }


    // Font properties
    property string fontName: "Nokia Sans"
    property int fontSize: 18
    property color fontColor: "black"
    // Images for switch states
    property string imageOn: theme_manager.theme.switch_on
    property string imageOff:theme_manager.theme.switch_off
    // Property indicating current state
    property bool switchedOn: true
    // Labels for the states
    property alias textOn: textOn.text
    property alias textOff: textOff.text
    // Spacing between labels and switch
    property alias spacing: row.spacing

    // Signal that gets fired when switch state has been toggled
    signal switched(bool position)

    width: row.width
    height: 44

    Row {
        id: row
        spacing: 8
        Text {
            id: textOn
            text: "Bật"
            height: container.height
            color: container.fontColor
            font {
                family: container.fontName
                pointSize: container.fontSize
            }
            verticalAlignment: Text.AlignVCenter
        }
        Image {
            id: toggleSwitch
            height: container.height
            width: 2.22 * height
            source: switchedOn ? imageOn : imageOff
            fillMode: Image.PreserveAspectFit
            smooth: true
        }
        Text {
            id: textOff
            height: container.height
            text: "Tắt"
            color: container.fontColor
            font {
                family: container.fontName
                pointSize: container.fontSize
            }
            verticalAlignment: Text.AlignVCenter
        }
    }
    MouseArea {
        anchors.fill: row
        onClicked: { switchedOn = !switchedOn; switched(switchedOn) }
    }
}
