/*
 *  lenscover reminder control panel plugin.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <locale.h>
#include <hildon/hildon.h>
#include <gconf/gconf-client.h>
#include "lens-cover-reminder-cp.h"

#define MCE_INI_FILE "/etc/mce/mce.ini"
#define LED_PATTERN_INI_GROUP_NAME "LEDPatternLystiRX51"
#define VIBRA_PATTERN_INI_GROUP_NAME "VibraPatternRX51"
#define GC_ROOT "/apps/maemo/lens-cover-reminder/"


void touch_text_selector_select_entry(HildonTouchSelector* selector,
				      const gchar* entry)
{
  GtkTreeIter iter;
  GtkTreeModel* tree_model = hildon_touch_selector_get_model(selector, 0);
  gboolean valid = gtk_tree_model_get_iter_first(tree_model, &iter);
  while(valid)
  {
    gchar* key;
    gtk_tree_model_get(tree_model, &iter,
		       0, &key,
		       -1);
    if(g_strcmp0(key, entry)==0)
    {
      valid = FALSE;
      hildon_touch_selector_select_iter(selector, 0,
					&iter, TRUE);
    }
    g_free(key);			 
    valid = valid && gtk_tree_model_iter_next(tree_model, &iter);
  }
}

void load_values(HildonCheckButton* device_lock,
		 HildonTouchSelector* vibra_selector,
		 HildonTouchSelector* notification_led_selector)
{
  GConfClient* client = gconf_client_get_default();
  g_assert(GCONF_IS_CLIENT(client));
  
  gchar* vibra_pattern = gconf_client_get_string(client, GC_ROOT "vibra", NULL);

  if(vibra_pattern == NULL)
  {
    vibra_pattern = g_strdup("PatternIncomingMessage");
  }
  touch_text_selector_select_entry(vibra_selector, vibra_pattern);
  g_free(vibra_pattern);
  gchar* led_pattern = gconf_client_get_string(client, GC_ROOT "led", NULL);
  if(led_pattern == NULL)
  {
    hildon_touch_selector_set_active(notification_led_selector, 0, 0);
  }
  else
  {
    touch_text_selector_select_entry(notification_led_selector, led_pattern);
    g_free(led_pattern);
  }
  
  gboolean lock = gconf_client_get_bool(client, GC_ROOT "lock_device", NULL);
  hildon_check_button_set_active(device_lock, lock);
  g_object_unref(client);
}

void load_pattern(HildonTouchSelector* selector,
			const gchar* groupName)
{
  GKeyFile* keyFile;
  gboolean fileExists;
  keyFile = g_key_file_new();
  fileExists = g_key_file_load_from_file(keyFile, MCE_INI_FILE, G_KEY_FILE_KEEP_COMMENTS, NULL);
  if(fileExists)
  {
    GError* error = NULL;
    gsize length = 0;
    gchar** patterns = g_key_file_get_keys(keyFile, groupName, &length, &error);
    if(error)
    {
      g_warning(error->message);
      g_error_free(error);
      error = NULL;
    }
    else
    {
      gchar** patterns_iter = patterns;
      while(*patterns_iter)
      {
	hildon_touch_selector_append_text(selector,
					  *patterns_iter);
	++patterns_iter;
      }
    }
    g_strfreev(patterns);
  }
  g_key_file_free(keyFile);
}

osso_return_t execute(osso_context_t* osso, gpointer data, gboolean user_activated)
{
  GtkWidget* dialog = gtk_dialog_new_with_buttons("Settings",
						  GTK_WINDOW(data),
						  GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
						  dgettext("hildon-libs", "wdgt_bd_done"), GTK_RESPONSE_OK,
						  NULL);
  
  GtkWidget* box = gtk_vbox_new(TRUE, 4);
  GtkWidget* vibra_button = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
						       HILDON_BUTTON_ARRANGEMENT_VERTICAL);
  GtkWidget* notification_led_button = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
								HILDON_BUTTON_ARRANGEMENT_VERTICAL);
  GtkWidget* vibra_selector = hildon_touch_selector_new_text();
  GtkWidget* notification_led_selector = hildon_touch_selector_new_text();

  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(vibra_selector),
				    "Disabled");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(notification_led_selector),
				    "Disabled");

  load_pattern(HILDON_TOUCH_SELECTOR(vibra_selector), VIBRA_PATTERN_INI_GROUP_NAME);  
  load_pattern(HILDON_TOUCH_SELECTOR(notification_led_selector), LED_PATTERN_INI_GROUP_NAME);  

  hildon_button_set_title(HILDON_BUTTON(vibra_button),
			  "Vibra");
  hildon_button_set_title(HILDON_BUTTON(notification_led_button),
			  "LED");
  hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(vibra_button),
				    HILDON_TOUCH_SELECTOR(vibra_selector));

  hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(notification_led_button),
				    HILDON_TOUCH_SELECTOR(notification_led_selector));


  gtk_box_pack_start(GTK_BOX(box), vibra_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(box), notification_led_button, TRUE, TRUE, 0);
  GtkWidget* frame = gtk_frame_new("Notification");
  GtkWidget* frame2 = gtk_frame_new("Close lens cover");
  GtkWidget* device_lock = hildon_check_button_new(HILDON_SIZE_FINGER_HEIGHT);
  load_values(HILDON_CHECK_BUTTON(device_lock), 
	      HILDON_TOUCH_SELECTOR(vibra_selector), 
	      HILDON_TOUCH_SELECTOR(notification_led_selector));

  gtk_button_set_label(GTK_BUTTON(device_lock), "Lock device");
  gtk_container_add(GTK_CONTAINER(frame), box);
  gtk_container_add(GTK_CONTAINER(frame2), device_lock);
  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), frame2);
  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), frame);
  
  gtk_widget_show_all(dialog);
  
  guint response = gtk_dialog_run(GTK_DIALOG(dialog));
  if(response == GTK_RESPONSE_OK)
  {
    GConfClient* client = NULL;
    client = gconf_client_get_default();
    g_assert(GCONF_IS_CLIENT(client));
    gchar* vibra_pattern = hildon_touch_selector_get_current_text(HILDON_TOUCH_SELECTOR(vibra_selector));
    gchar* notification_led_pattern = hildon_touch_selector_get_current_text(HILDON_TOUCH_SELECTOR(notification_led_selector));
    gconf_client_set_string(client, GC_ROOT "vibra", vibra_pattern, NULL); 
    gconf_client_set_string(client, GC_ROOT "led", notification_led_pattern, NULL); 
    gconf_client_set_bool(client, GC_ROOT "lock_device", hildon_check_button_get_active(HILDON_CHECK_BUTTON(device_lock)), NULL);
    g_free(vibra_pattern);
    g_free(notification_led_pattern);
    g_object_unref(client);
  }
  gtk_widget_destroy(GTK_WIDGET(dialog));
  return OSSO_OK;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
  return OSSO_OK;
}
