/*
 * radiolist.h -- Show the list of available radio allowing user to select one
 *
 * Copyright (C) 2010 Andrea Grandi
 * Authors: Andrea Grandi <a.grandi@gmail.com>
 *
 * This file is part of LastGo and is published under the GNU GPLv2
 * See the README file for more details.
 */

#ifndef RADIOLIST_H
#define RADIOLIST_H

#include <QDialog>
#include <QList>
#include <QMap>
#include <QListWidgetItem>

namespace Ui {
    class RadioList;
}

class RadioList : public QDialog
{
    Q_OBJECT

public:
    explicit RadioList(QString user, QWidget *parent = 0);
    ~RadioList();
    QString radioName;
    QString radioUrl;

private:
    Ui::RadioList *ui;
    QList<QMap<QString, QString> > radios;
    QString username;
    void initializeRadioList();
    void initializeListView();

private slots:
    void radioSelected(QListWidgetItem *item);

};

#endif // RADIOLIST_H
