/*
 * apiclient.h -- Contains all methods related to Last.fm API
 *
 * Copyright (C) 2010 Andrea Grandi
 * Authors: Andrea Grandi <a.grandi@gmail.com>
 *
 * This file is part of LastGo and is published under the GNU GPLv2
 * See the README file for more details.
 */

#ifndef APICLIENT_H
#define APICLIENT_H

#include <QObject>
#include <QString>
#include <QMap>

#include "requests.h"
#include "utils.h"
#include "lastfmtrack.h"

class ApiClient : public QObject
{
    Q_OBJECT
public:
    explicit ApiClient(QString api_key, QString api_secret, QObject *parent = 0);
    void authGetMobileSession(QString username, QString password);
    void userShout(QString user, QString message, QString sk);
    void radioTune(QString station, QString sk);
    void radioGetPlaylist(QString sk);
    void scrobblerHandshake(QString protocol, QString clientId, QString clientVersion,
                            QString user, QString timestamp, QString token, QString api_key, QString sk);
    void scrobblerPlaying(QString playingUrl, QString sessionId, QString artist, QString track, QString album,
                          QString trackLenght, QString trackNumber, QString mbTrackId);
    void scrobblerSubmission(QString scrobblingUrl, QString sessionId, QString artist, QString track, QString timestamp,
                             QString source, QString rating, QString trackLenght,
                             QString album, QString trackNumber, QString mbTrackId);
    void setApiKey(QString apikey);
    void setApiSecret(QString apisecret);

private:
    QString api_key;
    QString api_secret;
    QString auth_token;

signals:
    void authGetMobileSessionData(QMap<QString, QString> reply);
    void userShoutData(QMap<QString, QString> reply);
    void radioTuneData(QMap<QString, QString> reply);
    void radioGetPlaylistData(QList<LastfmTrack*> tracks);
    void radioGetPlaylistError(QMap<QString, QString> error);
    void scrobblerHandshakeData(QMap<QString, QString> reply);
    void scrobblerPlayingData(QString data);
    void scrobblerSubmissionData(QString data);

public slots:

private slots:
    void authGetMobileSessionReply(QString data);
    void userShoutReply(QString data);
    void radioTuneReply(QString data);
    void radioGetPlaylistReply(QString data);
    void scrobblerHandshakeReply(QString data);
    void scrobblerPlayingReply(QString data);
    void scrobblerSubmissionReply(QString data);

};

#endif // APICLIENT_H
