/*
 * This file is part of jSpeed.
 *
 * jSpeed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * jSpeed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with jSpeed.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef GRAPHICSSCREEN_H
#define GRAPHICSSCREEN_H

#include <QtGui/QGraphicsView>
#include "abstractscreen.h"

class GraphicsScene;
class ToolbarItem;

class GraphicsScreen : public QGraphicsView, public AbstractScreen
{
    Q_OBJECT

public:
    enum Orientation {LANDSCAPE, PORTRAIT};
    GraphicsScreen(QWidget* parent = 0);
    virtual ~GraphicsScreen();

signals:
    void minimizePressed();
    void settingsPressed();
    void closePressed();
    void clicked();

public slots:
    virtual void update() = 0;
    virtual void reArrange();
    void flip();
    void forceRepaint();

protected:
    GraphicsScene* getScene() const;

private:
    GraphicsScene* scene_;
    ToolbarItem* minimizeButton_;
    ToolbarItem* settingsButton_;
    ToolbarItem* closeButton_;
    int imageWidth_;
    bool isFlipped_;
};

#endif
