#!/usr/bin/env python

import os, sys, pygame, math, random, ConfigParser
from pygame.locals import *
import gst

bpp=16
showfps=False
startlevel=0
fullscreenrefresh=False

pos_close =(720,10)

bgimg = "/images/background3.jpg"

appdir = ''

appdir = sys.argv[0]
appdir = os.path.dirname(appdir)
appdir =os.path.abspath(appdir)
settingsdir=appdir+'/settings'

print "PATH: " + appdir

oggplayer = gst.element_factory_make("playbin2","player")    
bus = oggplayer.get_bus()

spritecolor =[255,0,0]
redcolor=[255,0,0]
greencolor=[0,255,0]
bluecolor=[0,0,255]
yellowcolor=[255,255,0]
orangecolor=[255,127,0]

config = ConfigParser.RawConfigParser()

def getdefint(sct,key,val):
    try: 
        return config.getint(sct, key)
    except:
        return val

def saveconfig():
    configfile = open(settingsdir +'/issettings.cfg', "w")
    print "writting settings"
    config.write(configfile)

try:
    configfile = open(settingsdir +'/issettings.cfg', "r")
    config.readfp(configfile)
    hiscore = getdefint('achievements', 'highscore',2000)
    playsounds=getdefint('settings', 'sound',1)==1
    showfps=getdefint('settings', 'showfps',0)==1
    startlevel=getdefint('settings', 'startlevel',0)
    fullscreenrefresh=getdefint('settings', 'fullscreenrefresh',0)==1
except:
    print configfilename + " - read failure, picking defaults"
    hiscore = 2000
    playsounds=True
    showfps=False
    
#configfile = open(settingsdir +'/issettings.cfg', "w")
try:
    config.add_section('achievements')
except ConfigParser.DuplicateSectionError:
    pass

try:
    config.add_section('settings')
except ConfigParser.DuplicateSectionError:
    pass

config.set('achievements','highscore', str(hiscore))
saveconfig()
#configfile.seek(0)
#config.write(configfile)

numcirclecolors=5

circlecolors=[redcolor,greencolor,bluecolor,yellowcolor,orangecolor]
bkcolor =[255,63,63]
outlinecolor =[0,0,0]
centerpoint = [400,240]

unlitimages=[]
litimages=[]
for i in range(5):
    clr = circlecolors[i]
    if os.path.exists(appdir + "/ccl"+str(i)+".png"):
        pass
    else:
        curcolor=[0,0,0]
        cimage = pygame.Surface((32,32))
        cimage.fill(bkcolor)
        for i in range(8):
            for j in range(3):
                curcolor[j]=(clr[j]*i)/8               
            pygame.draw.circle(cimage,curcolor,(16,16),15-i)
            
        cimage.set_colorkey( cimage.get_at((0,0)) )
        unlitimages.append(cimage)

        cimage = pygame.Surface((32,32))
        cimage.fill(bkcolor)
        for i in range(8):
            for j in range(3):
                curcolor[j]=((clr[j]*i)/8) + ((227*(8-i)/8))
                if curcolor[j]>255:
                    curcolor[j]=255               
            pygame.draw.circle(cimage,curcolor,(16,16),15-i)
        cimage.set_colorkey( cimage.get_at((0,0)) )
        litimages.append(cimage)
 

lvltime=2000

innercolors=[[255,200,200],[200,255,200],[200,200,255]]
innerwidths=[180,140,100]
positions=[0,20,40,60,80,
           100,120,140,160,180,
           200,220,240,260,280,
           300,320,340]

numsprites=6
outerwidth = 220

gcsnum=0

pauseIconTop=202
soundIconTop=390

InfoIconTop=390
InfoIconLeft=20

class CircleSprite(pygame.sprite.Sprite):
    tickoffset=0
    csnum=0
    lit=False
    waslit=False
    first=True
    lightimage=0
    color=0
    angle=-99999

    def getimage(self):
        if self.lit:
            return litimages[self.colorindx] 
        else:
            return unlitimages[self.colorindx]

    def __init__(self,colorindx,atickoffset):       
        global gcsnum
        self.color=circlecolors[colorindx]
        self.colorindx=colorindx
        self.csnum=gcsnum
        gcsnum=gcsnum+1

        self.backrect = Rect((0,0),(31,31))
        self.rect=Rect((0,0),(31,31))

        pygame.sprite.Sprite.__init__(self)
        self.tickoffset=atickoffset

def grayscale_image(surf):
    width, height = surf.get_size()
    for x in range(width):
        for y in range(height):
            red, green, blue, alpha = surf.get_at((x, y))
            L = 0.3 * red + 0.59 * green + 0.11 * blue
            gs_color = (L, L, L, alpha)
            surf.set_at((x, y), gs_color)
    return surf

def transparentise(surf,maxalpha):
    width, height = surf.get_size()
    for x in range(width):
        for y in range(height):
            red, green, blue, alpha = surf.get_at((x, y))
            L = 0.3 * red + 0.59 * green + 0.11 * blue
            if alpha > maxalpha:
                alpha = maxalpha
            gs_color = (red, green, blue, alpha)
            surf.set_at((x, y), gs_color)
    return surf


soundicon = 0
musicicon = 0

def renderbuttons(background):
    global soundicon
    global soundicongs
    global infoicon
    global infoicongs
    global pauseicon
    global pauseicongs
    global xicon
    global xicongs

    global islogo

    if soundicon == 0:

        soundicon = pygame.image.load(appdir + "/Icons/sound.png")
        soundicongs = pygame.image.load(appdir + "/Icons/sound.png")

        soundicongs = grayscale_image(soundicongs)

        pauseicon = pygame.image.load(appdir + "/Icons/lock.png")
        pauseicongs = pygame.image.load(appdir + "/Icons/lock.png")
        pauseicongs = grayscale_image(pauseicongs)

        xicon = pygame.image.load(appdir + "/Icons/shut_down.png")
        xicongs = pygame.image.load(appdir + "/Icons/shut_down.png")
        xicongs = grayscale_image(xicongs)

        infoicon = pygame.image.load(appdir + "/Icons/info.png")
        infoicongs = pygame.image.load(appdir + "/Icons/info.png")
        infoicongs = grayscale_image(infoicongs)

    if playsounds:
        background.blit(soundicon, (724,soundIconTop))
    else:
        background.blit(soundicongs, (724,soundIconTop))

    background.blit(infoicongs, (InfoIconLeft,InfoIconTop))

    background.blit(pauseicongs, (720,pauseIconTop))
    background.blit(xicongs, pos_close)

def setupbackground():
    background = pygame.image.load(appdir + bgimg)
    for i in range(3):
        pygame.draw.circle(background,innercolors[i],centerpoint,innerwidths[i] + 3,6)
        hoff=60 +(i*30)
        woff=30 + (50*i)

    pygame.draw.circle(background,[255,255,255],centerpoint,outerwidth +3,6)

    for i in range(36):
        angle=math.radians(i*10)
        pygame.draw.line(background,[255,255,255],
            [centerpoint[0]+(math.sin(angle)*innerwidths[2]),
            centerpoint[1]+(math.cos(angle)*innerwidths[2])],
            [centerpoint[0]+(math.sin(angle)*outerwidth),
            centerpoint[1]+(math.cos(angle)*outerwidth)])

    renderbuttons(background)

    return background

class Level():

    def __init__(self,levelNo):
        print "Created Level: " + str(levelNo)

        self.levelcircles=[]
        self.innercircles=[[],[],[]]
        if (levelNo%2) == 0:
            self.spinspeed=(0.025 * levelNo)
        else:
            self.spinspeed=(-0.025 * levelNo)

        self.numsprites=8 + int(levelNo/3)
        if self.numsprites >18:
            self.numsprites = 18

        self.outersprites=[]
        self.innersprites=[]

        rndps = positions
        random.shuffle(rndps)
        for i in range(self.numsprites):
            clrindx=random.randint(0,numcirclecolors-1)
            clr=circlecolors[clrindx]
            self.levelcircles.append([rndps[i],clr])
            circleno=random.randint(0,2)
            self.innercircles[circleno].append(i)
            bs = CircleSprite(clrindx,self.levelcircles[i][0])
            bs.lit=False
            bs.radius = outerwidth
            self.outersprites.append(bs)
            bs = CircleSprite(clrindx,self.levelcircles[i][0])
            bs.lit=False
            bs.radius = innerwidths[circleno]
            self.innersprites.append(bs)


def handlebuttonpress(event,screen,background):
    global playsounds
#    global playmusic
    if (event.pos[0]>720) and (event.pos[1]<70):
        print "closing"
        infosnd=pygame.mixer.Sound(appdir + "/sounds/exit.wav")
        screen.blit(xicon, pos_close)
        pygame.display.flip()
        if playsounds:
            soundplay(infosnd)
            pygame.time.wait(750)
            oggplayer.set_state(gst.STATE_NULL)
            pygame.time.wait(750)
        else:
            pygame.time.wait(500)
        quit()
        return False
    elif (event.pos[0]>720) and (event.pos[1])>pauseIconTop and (event.pos[1])<pauseIconTop+64:
        pause(screen,background,False)
        return True
    elif (event.pos[0]>720) and (event.pos[1])>soundIconTop and (event.pos[1])<soundIconTop+64:
        playsounds= not playsounds

        if playsounds:
            soundonsnd=pygame.mixer.Sound(appdir + "/sounds/soundon.wav")
            soundplay(soundonsnd)
            config.set('settings','sound', '1')
            saveconfig()
#            configfile.seek(0)
#            config.write(configfile)
        else:
            config.set('settings','sound', '0')
            saveconfig()
#            configfile.seek(0)
#            config.write(configfile)

        if playsounds:
            oggplayer.set_state(gst.STATE_PLAYING)
        else:
            oggplayer.set_state(gst.STATE_PAUSED)
    
        renderbuttons(background)
        renderbuttons(screen)
        pygame.display.flip()
        return True
    elif (event.pos[0]<80) and (event.pos[1])>InfoIconTop and (event.pos[1])<InfoIconTop+64:
        showInfo(screen,background)
        return True
    else:
        return False


def main():
    global appdir
    appdir = sys.argv[0]
    appdir = os.path.dirname(appdir)
    appdir =os.path.abspath(appdir)
    print "PATH: " + appdir
    pygame.init()
    pygame.mixer.init()
    pygame.mouse.set_visible(False)

    flags=FULLSCREEN
    screen=pygame.display.set_mode((800,480),flags,bpp)

    print pygame.display.get_driver()
    print pygame.display.get_surface()
    score=-1
    while Betweengames(score,screen):
        score = PlayGame(screen)
        if score < 0:
            return True

#def donothing():
#    i=0

def Betweengames(score, screen):
    global hiscore

    oggplayer.set_state(gst.STATE_NULL)
    oggplayer.set_property('uri', 'file://' + appdir + "/sounds/TTGTB.mp3")
    if playsounds:
        oggplayer.set_state(gst.STATE_PLAYING)
    else:
        oggplayer.set_state(gst.STATE_PAUSED)

    background = pygame.image.load(appdir + bgimg)
    renderbuttons(background)
    font = pygame.font.Font(None, 32)
    scorefont = pygame.font.Font(None, 128)

    if score > hiscore:
        hiscore=score

    text = font.render('Highscore: ' + str(hiscore), True, (255,255,255), (0,64,0))        

    text.set_colorkey((0,64,0))
    textRect = text.get_rect(centerx=400,centery=120)
    background.blit(text,textRect)

    if score >= 0:
        text = scorefont.render(str(score), True, (255,255,255), (0,64,0))
    else:
        text = scorefont.render("INNER SPIN", True, (255, 127, 127), (0,64,0))
        
    text.set_colorkey((0,64,0))
    textRect = text.get_rect(centerx=400,centery=220)
    background.blit(text,textRect)

    text = font.render('INNER SPIN - touch screen to start', True, (255,255, 255), (0,64,0))
    # Create a rectangle
    text.set_colorkey((0,64,0))
    textRect = text.get_rect(centerx=400,centery=350)
    background.blit(text,textRect)

#    pygame.display.flip()
    screen.blit(background,(0,0))
    clock = pygame.time.Clock()
    xpos=0
    rect= Rect((0,0),(8,480))
    clock = pygame.time.Clock()
    while rect.left <800:
        clock.tick(60)
        rect.centerx=xpos
        xpos=xpos+8
        pygame.display.update([rect])


    if score >= 0:
        if score == hiscore:
            infosnd=pygame.mixer.Sound(appdir + "/sounds/highscore.wav")
        elif score < 800:   
            infosnd=pygame.mixer.Sound(appdir + "/sounds/badscore.wav")
        elif score < 1600:   
            infosnd=pygame.mixer.Sound(appdir + "/sounds/okscore.wav")
        elif score < 3200:   
            infosnd=pygame.mixer.Sound(appdir + "/sounds/goodscore.wav")
        elif score < 6400:   
            infosnd=pygame.mixer.Sound(appdir + "/sounds/excellentscore.wav")
        else:
            infosnd=pygame.mixer.Sound(appdir + "/sounds/fantasticscore.wav")
        soundplay(infosnd)

    if score == hiscore:
        config.set('achievements','highscore', str(score))
        saveconfig()
#        configfile.seek(0)
#        config.write(configfile)

    mdown=False
    while 1:
        message = bus.poll(gst.MESSAGE_EOS,0)
        if message != None:
            return True

        clock.tick(10)
#       pretty hideous way of detcting song end... but seems to work
        message = bus.poll(gst.MESSAGE_EOS,0)
        if message != None:
            return True


        for event in pygame.event.get():
            if event.type == QUIT:
                return False
            if event.type == MOUSEBUTTONDOWN:
                if handlebuttonpress(event,screen,background):
                    pass
                else:
                    mdown=True
            if event.type == MOUSEBUTTONUP:
                if mdown:
                    return True


def anglediff(a1, a2):
    a1 = a1 % 360
    if a1<0:
        a1=a1 + 360
    a2 = a2 % 360
    if a2<0:
        a2=a2 + 360
    if a1 > a2:
        t = a1
        a1 = a2
        a2 = t
    d1 = a2 - a1
    d2 = (a1 + 360) - a2
    if d1 < d2:
        return d1
    else:
        return d2

def soundplay(sound):
    if playsounds:
        sound.stop()
        sound.play()

def calcspritetl(angle, distance):
    rang = math.radians(angle)
    x = 384+(math.cos(rang) * distance)
    y = 224+(math.sin(rang) * distance)
    return (x,y)

def pause(screen,background,silent):
    oggplayer.set_state(gst.STATE_PAUSED)

    infosnd=pygame.mixer.Sound(appdir + "/sounds/pause.wav")
    soundplay(infosnd)
    savebackground =pygame.Surface((800,480))
    savebackground.blit(screen,(0,0,800,480))
    screen.blit(pauseicon,(720,pauseIconTop))
    pygame.display.flip()
    clock = pygame.time.Clock()
    mdown=False
    while 1:
        clock.tick(10)
        for event in pygame.event.get():
            if event.type == QUIT:
                return False
            if event.type == MOUSEBUTTONDOWN:
                mdown=True
            if event.type == MOUSEBUTTONUP:
                if mdown:
                    if playsounds:
                        oggplayer.set_state(gst.STATE_PLAYING)
                    screen.blit(savebackground, (0,0,800,480))  
                    pygame.display.flip()
                    return True

#hideous copy paste ToDo unify with Pause 
def showInfo(screen,background):
    oggplayer.set_state(gst.STATE_PAUSED)
    savebackground =pygame.Surface((800,480))
    savebackground.blit(screen,(0,0,800,480))
    infosnd=pygame.mixer.Sound(appdir + "/sounds/info.wav")
    soundplay(infosnd)

    textsurf = pygame.Surface((600,440))
    clrinfo=[255,200,200]
    textsurf.fill(clrinfo)
    pygame.draw.rect(textsurf,[0,0,127],(0,0,600,440),5)

    font = pygame.font.Font(None, 38)
    headfont = pygame.font.Font(None, 64)
        
    screen.blit(infoicon,(InfoIconLeft,InfoIconTop))
    pygame.display.flip()

    text = headfont.render("INNER SPIN", True, (0, 0, 127), clrinfo)
    textRect = text.get_rect(centerx=300,centery=60)
    textsurf.blit(text,textRect)

    text = font.render("Light all the colours on the outer circle", True, (0, 0, 0), clrinfo)
    textRect = text.get_rect(centerx=300,centery=140)
    textsurf.blit(text,textRect)

    text = font.render("by rotating the inner circles", True, (0, 0, 0), clrinfo)
    textRect = text.get_rect(centerx=300,centery=170)
    textsurf.blit(text,textRect)

    text = font.render("BUT HURRY", True, (0, 0, 0), clrinfo)
    textRect = text.get_rect(centerx=300,centery=205)
    textsurf.blit(text,textRect)
    
    text = font.render("Max is counting.", True, (0, 0, 0), clrinfo)
    textRect = text.get_rect(centerx=300,centery=240)
    textsurf.blit(text,textRect)

    text = font.render("Game by", True, (0, 0, 0), clrinfo)
    textRect = text.get_rect(centerx=300,centery=305)
    textsurf.blit(text,textRect)

    text = font.render("Tony Day and Max Seth Taylor Day", True, (0, 0, 0), clrinfo)
    textRect = text.get_rect(centerx=300,centery=340)
    textsurf.blit(text,textRect)

    text = font.render("High Score by Ava, Max and Rachel", True, (0, 0, 0), clrinfo)
    textRect = text.get_rect(centerx=300,centery=375)
    textsurf.blit(text,textRect)

    text = font.render("Icons by DryIcons (http://dryicons.com)", True, (0, 0, 0), clrinfo)
    textRect = text.get_rect(centerx=300,centery=410)
    textsurf.blit(text,textRect)

    textsurf.set_alpha(225)

    screen.blit(textsurf,(100,20))       


    ypos=0
    rect= Rect((0,0),(800,8))
    clock = pygame.time.Clock()
    while rect.top < 480:
        clock.tick(60)
        rect.centery=ypos
        ypos=ypos+8
        pygame.display.update([rect])

    clock = pygame.time.Clock()
    mdown=False
    while 1:
        clock.tick(10)
        for event in pygame.event.get():
            if event.type == QUIT:
                return False
            if event.type == MOUSEBUTTONDOWN:
                mdown=True
            if event.type == MOUSEBUTTONUP:
                if mdown:
                    if playsounds:
                        oggplayer.set_state(gst.STATE_PLAYING)
                    screen.blit(savebackground, (0,0,800,480))  
                    pygame.display.flip()
                    return True

def PlayGame(screen):
    oggplayer.set_state(gst.STATE_NULL)
    oggplayer.set_property('uri', 'file://' + appdir + "/sounds/AlienMFC3.mp3")

    if playsounds:
        oggplayer.set_state(gst.STATE_PLAYING)
    else:
        oggplayer.set_state(gst.STATE_PAUSED)

    score = 0
    levelNo = startlevel
    timeremaining=lvltime
    mdown=False
    level = Level(levelNo)
    lastlevel = levelNo - 1
    lastscore= -1
    # Create a font
    font = pygame.font.Font(None, 48)
    cdfont = pygame.font.Font(None, 100)
    text = font.render('', True, (255,255, 255), (0,64,0))

    # Create a rectangle
    textRect = text.get_rect()
    timetextRect = textRect
    leveltextRect = textRect
    fpstextRect = textRect
    countdowntextRect = textRect

    # Create a sound..
    lvldonesnd=pygame.mixer.Sound(appdir + "/sounds/excellent.wav")
    lghtonsnd= pygame.mixer.Sound(appdir + "/sounds/lighton.wav")
    lghtonsnd.set_volume(0.1)
    lghtoffsnd= pygame.mixer.Sound(appdir + "/sounds/lightoff.wav")
    lghtoffsnd.set_volume(0.1)
    timesupsnd=pygame.mixer.Sound(appdir + "/sounds/timesup.wav")
    hurrysnd=pygame.mixer.Sound(appdir + "/sounds/hurry.wav")
    playedhurry=False
    letsgosnd=pygame.mixer.Sound(appdir + "/sounds/letsgo.wav")

    countsndarray=[]
    for i in range(10):
         countsndarray.append(pygame.mixer.Sound(appdir + "/sounds/"+str(i+1)+"count.wav"))

    lastcount=10
    countdown=True

    soundplay(letsgosnd)
    
    background = setupbackground()

    haseffects=False

    screen.blit(background,(0,0))
    rectlist=[background.get_rect()]
    clock = pygame.time.Clock()

    angleoffset =[]
    effectsprites=[]
    for i in range(3):
        minangel =360
        for cpos in level.innercircles[i]:
            if level.levelcircles[cpos][0] < minangel:
                 minangel = level.levelcircles[cpos][0]
        angleoffset.append(random.randint(0,359))

    ticker=0
    currcircle=0

    while timeremaining > 0:
#       pretty hideous way of looping mp3... but seems to work
        message = bus.poll(gst.MESSAGE_EOS,0)
        if message != None:
            print "EOS message popped (rewinding)"
            oggplayer.seek_simple(gst.FORMAT_TIME, gst.SEEK_FLAG_FLUSH, 0)

        gameticks = clock.tick(60)*60/1000
    
        if gameticks < 1:
            gameticks = 1
        if gameticks > 3:
            gameticks = 3

        ticker = ticker + (level.spinspeed*gameticks)
        if ticker >=360:
            ticker = ticker -360
        elif ticker <= 0:
            ticker = ticker +360

        fps = clock.get_fps()
        # handle events
        for event in pygame.event.get():
            if event.type == QUIT:
                return False
            if event.type == MOUSEBUTTONDOWN:
                if handlebuttonpress(event,screen,background):
                    pass
                else:
                    mdown = True
                    dist = math.sqrt((event.pos[0] - centerpoint[0])**2
                         + (event.pos[1] - centerpoint[1])**2)

                    if dist > 160:
                        currcircle = 0
                    elif dist < 120:
                        currcircle = 2
                    else:
                        currcircle = 1

                    angle=math.atan2((event.pos[1] - centerpoint[1]),(event.pos[0] - centerpoint[0]))
                    angle=math.degrees(angle)
                    currangleoffset = angle - angleoffset[currcircle]
                    dir = 1

            if event.type == MOUSEBUTTONUP:
                mdown=False

            if event.type == MOUSEMOTION:
                if mdown:
                    angle=math.atan2((event.pos[1] - centerpoint[1]),(event.pos[0] - centerpoint[0]))
                    angle=math.degrees(angle)
                    angleoffset[currcircle]=angle - currangleoffset


# first do all our screen recovery

        for i in range(level.numsprites):
            bs = level.outersprites[i]
            screen.blit(background, bs.rect, bs.rect)
            bs.backrect.topleft=bs.rect.topleft
            bs.backrect.bottomright=bs.rect.bottomright
            bs.angle = ticker + bs.tickoffset
            if bs.angle >= 360:
                bs.angle = bs.angle - 360
            elif bs.angle <= 0:
                bs.angle = bs.angle + 360

        for i in range(3):
            for cpos in level.innercircles[i]:
                bs = level.innersprites[cpos]
                bs.backrect.topleft=bs.rect.topleft
                bs.backrect.bottomright=bs.rect.bottomright
                bs.waslit=bs.lit
                wasangle=bs.angle
                bs.angle = angleoffset[i] + level.levelcircles[cpos][0]
                bs.rect.topleft = calcspritetl(bs.angle,innerwidths[i])
                if mdown and (i == currcircle) and (bs.rect != bs.backrect):
                    screen.blit(background, bs.backrect, bs.backrect)

# Render Effects recovery...
        if haseffects:
            haseffects=False
            for bs in effectsprites:
                if bs.radius < 500:
                    screen.blit(background, bs.rect, bs.rect)
                    rectlist.append(bs.rect)
                    haseffects=True

# Render text...

        if haseffects or (score != lastscore):
            screen.blit(background, textRect, textRect)
            rectlist.append(textRect)
            text = font.render('Score: '+str(score),
                   True, (255,255, 255), (0,64,0))

            # Create a rectangle
            text.set_colorkey((0,64,0))
            textRect = text.get_rect()
            textRect.topleft = (20,20)
            screen.blit(text,textRect)
            rectlist.append(textRect)
            lastscore=score

        if haseffects or (levelNo != lastlevel):
            screen.blit(background, timetextRect, timetextRect)
            rectlist.append(timetextRect)
            text = font.render('Level: '+str(levelNo +1),
                           True, (255,255, 255), (0,64,0))

            text.set_colorkey((0,64,0))

            # Create a rectangle
            timetextRect = text.get_rect()
            timetextRect.topleft = (20,60)
            screen.blit(text,timetextRect)
            rectlist.append(timetextRect)
            lastlevel=levelNo

        drawtext = False
        color=(255,255,255)
        cdalpha=255
        if ((timeremaining%200)<25):
            cdalpha=255-(10*(25 - (timeremaining%200)))
            drawtext=True
        elif (200 - (timeremaining%200))<25:
            cdalpha=255-(10*(25 - (200 - (timeremaining%200))))
            drawtext=True

        normtimerem=(timeremaining/200)+ 1
        if (normtimerem > 0) and (normtimerem <= 10) and (normtimerem != lastcount):
            soundplay(countsndarray[normtimerem-1])
            lastcount=normtimerem

        if drawtext:
            screen.blit(background, countdowntextRect, countdowntextRect)
            rectlist.append(countdowntextRect)
            if (int(timeremaining)<=500) and not playedhurry:
                soundplay(hurrysnd)
                playedhurry=True

            text = cdfont.render(str(int(timeremaining/200) +1),
                       True, color, (0,64,0))

            text.set_colorkey((0,64,0))
            text.set_alpha(cdalpha)

            # Create a rectangle
            countdowntextRect = text.get_rect( centerx=400, centery=240)
            screen.blit(text,countdowntextRect)
            rectlist.append(countdowntextRect)


        if showfps:
                screen.blit(background, fpstextRect, fpstextRect)
                rectlist.append(fpstextRect)
                text = font.render('FPS: '+str(int(fps)),
                       True, (255,255, 255), (0,64,0))
                text.set_colorkey((0,64,0))
        
                # Create a rectangle
                fpstextRect = text.get_rect( centery=440)
                fpstextRect.topleft =(20,430)
                screen.blit(text,fpstextRect)
                rectlist.append(fpstextRect)
        

# next work out what is lit...

        for bs in level.outersprites:
            bs.waslit=bs.lit
            bs.lit=False

        for bs in level.innersprites:
            bs.waslit=bs.lit
            bs.lit=False


        for i in range(3):
            for cpos in level.innercircles[i]:
                bs1=level.innersprites[cpos]
                for bs2 in level.outersprites:
                    if (bs1.color == bs2.color) and (anglediff(bs1.angle,bs2.angle) < 6):
                        bs1.lit=True
                        bs2.lit=True

        alllit = True
        for bs in level.outersprites:
            alllit = alllit and bs.lit


# play sounds depending on state changes
        playon=False
        playoff=False
        for bs in level.outersprites:
            if bs.waslit and (not bs.lit):
                playoff=True
            elif bs.lit and (not bs.waslit):
                playon=True

        for bs in level.innersprites:
            if bs.waslit and (not bs.lit):
                playoff=True
            elif bs.lit and (not bs.waslit):
                playon=True

        if playon:
            soundplay(lghtonsnd)
        if playoff:
            soundplay(lghtoffsnd)

# now we render our new positions
        for i in range(level.numsprites):
            bs = level.outersprites[i]
            bs.backrect.topleft=bs.rect.topleft
            bs.backrect.bottomright=bs.rect.bottomright
            bs.rect.topleft = calcspritetl(bs.angle,outerwidth)
            screen.blit(bs.getimage(),bs.rect)
            rectlist.append(bs.backrect)
            rectlist.append(bs.rect)

        for i in range(3):
            for cpos in level.innercircles[i]:
                bs = level.innersprites[cpos]
                if haseffects or (bs.lit != bs.waslit) or (bs.backrect!=bs.rect):
                    screen.blit(bs.getimage(),bs.rect)
                    rectlist.append(bs.backrect)
                    if (bs.backrect!=bs.rect):
                        rectlist.append(bs.rect)

# Render Effects...
        if haseffects:
            haseffects=False
            for bs in effectsprites:
                if bs.radius < 500:
                    bs.backrect.topleft=bs.rect.topleft
                    bs.backrect.bottomright=bs.rect.bottomright
                    bs.rect.topleft = calcspritetl(bs.angle,bs.radius)
                    screen.blit(bs.getimage(),bs.rect)
                    rectlist.append(bs.backrect)
                    rectlist.append(bs.rect)
                    bs.radius= bs.radius+ 16
                    haseffects=True

        if fullscreenrefresh:
            pygame.display.flip()
        else:
            pygame.display.update(rectlist)
        
        if alllit:
            soundplay(lvldonesnd)
            playedhurry=False
            effectsprites=[]
            for bs in level.outersprites:
                effectsprites.append(bs)
            for bs in level.innersprites:
                effectsprites.append(bs)
            haseffects=True

            background = setupbackground()
            score=score + ((int(timeremaining/20) +1) * (levelNo +1))
            print "Completed Level: " + str(levelNo +1)
            print "timeremaining: " + str(timeremaining)
            print "score: " + str(score)
            print "New Level"
            levelNo = levelNo + 1
            # set mouse up (even if untrue)
            mdown=False
            # clear what went before...
            level = Level(levelNo)

            timeremaining=lvltime
            screen.blit(background,(0,0))
            pygame.display.flip()
# TODO - move this into the level
            angleoffset =[]
            for i in range(3):
                minangel =360
                for cpos in level.innercircles[i]:
                    if level.levelcircles[cpos][0] < minangel:
                         minangel = level.levelcircles[cpos][0]
                angleoffset.append(random.randint(0,359))
            ticker=0
        
        if countdown:
            timeremaining = timeremaining-gameticks
# Clear redraw rects....
        rectlist=[]

    screen.blit(background, countdowntextRect, countdowntextRect)
    rectlist.append(timetextRect)
    rectlist.append(countdowntextRect)
    soundplay(timesupsnd)
    text = cdfont.render("TIME'S UP!",
           True, (255,127,127), (0,64,0))

    text.set_colorkey((0,64,0))


    # Create a rectangle
    countdowntextRect = text.get_rect( centerx=400, centery=240)
    screen.blit(text,countdowntextRect)
    rectlist.append(countdowntextRect)
    pygame.display.update(rectlist)
#    oggplayer.disconnect(repeatid)
    return score


#import cProfile as profile
if __name__ == "__main__":
#    profile.run(main())
    main()
