/*
 * gcc `pkg-config --cflags --libs gtk+-2.0 libsocialweb-client` test-service.c -o test-services
 *
 */
#include <glib.h>
#include <libsocialweb-client/sw-client.h>

static void
callback (SwClientService *service,
		const GError    *error,
		gpointer         userdata)
{
	if (error) {
		g_warning ("Error: %s", error->message);
	} else {
		g_warning ("All is well.");
	}
}

int
main(int argc, char **argv)
{
	SwClient *client;
	SwClientService *service;
	
	gtk_init (&argc, &argv);

	client = sw_client_new ();

	service = sw_client_get_service (client,
		"twitter");

	sw_client_service_update_status (service,
		callback,
		"This is a test.  One two, one two.",
		NULL);

	gtk_main();

	g_object_unref (service);
	g_object_unref (client);
}

