/*
 * gcc `pkg-config --cflags --libs gtk+-2.0 libsocialweb-client` list-services.c -o list-services
 *
 */
#include <glib.h>
#include <libsocialweb-client/sw-client.h>

static void
dump_services (SwClient *client,
	const GList *stuff,
	gpointer userdata)
{
	const GList *cursor = stuff;

	while (cursor) {
		g_warning ("%s", cursor->data);
		cursor = cursor->next;
	}
}

int
main(int argc, char **argv)
{
	SwClient *client;
	
	gtk_init (&argc, &argv);

	client = sw_client_new ();

	sw_client_get_services (client,
		dump_services,
		NULL);

	gtk_main();

	g_object_unref (client);
}

