/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.tools.jconsole.resources.JConsoleResources;

public final class Resources {
    private static final Object lock = new Object();
    private static JConsoleResources resources = null;

    private Resources() {
        throw new AssertionError();
    }

    public static String getText(String key, Object ... args) {
        String format = Resources.getString(key);
        if (format == null) {
            format = "missing resource key: key = \"" + key + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        return Resources.formatMessage(format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String formatMessage(String format, Object ... args) {
        String ss = null;
        Object object = lock;
        synchronized (object) {
            ss = MessageFormat.format(format, args);
        }
        return ss;
    }

    public static int getMnemonicInt(String key) {
        int mnemonic = 0;
        if (resources != null) {
            Object obj = resources.getObject(key + ".mnemonic");
            if (obj instanceof Character) {
                mnemonic = ((Character)obj).charValue();
                if (mnemonic >= 97 && mnemonic <= 122) {
                    mnemonic -= 32;
                }
            } else if (obj instanceof Integer) {
                mnemonic = (Integer)obj;
            }
        }
        return mnemonic;
    }

    private static String getString(String key) {
        if (resources != null) {
            try {
                return resources.getString(key);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        return "missing resource bundle: key = \"" + key + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
    }

    static {
        try {
            resources = (JConsoleResources)ResourceBundle.getBundle("sun.tools.jconsole.resources.JConsoleResources");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

