/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.X500Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateSubjectName
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.subject";
    public static final String NAME = "subject";
    public static final String DN_NAME = "dname";
    public static final String DN_PRINCIPAL = "x500principal";
    private X500Name dnName;
    private X500Principal dnPrincipal;

    public CertificateSubjectName(X500Name name) {
        this.dnName = name;
    }

    public CertificateSubjectName(DerInputStream in) throws IOException {
        this.dnName = new X500Name(in);
    }

    public CertificateSubjectName(InputStream in) throws IOException {
        DerValue derVal = new DerValue(in);
        this.dnName = new X500Name(derVal);
    }

    @Override
    public String toString() {
        if (this.dnName == null) {
            return "";
        }
        return this.dnName.toString();
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.dnName.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof X500Name)) {
            throw new IOException("Attribute must be of type X500Name.");
        }
        if (!name.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
        }
        this.dnName = (X500Name)obj;
        this.dnPrincipal = null;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(DN_NAME)) {
            return this.dnName;
        }
        if (name.equalsIgnoreCase(DN_PRINCIPAL)) {
            if (this.dnPrincipal == null && this.dnName != null) {
                this.dnPrincipal = this.dnName.asX500Principal();
            }
            return this.dnPrincipal;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
        }
        this.dnName = null;
        this.dnPrincipal = null;
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(DN_NAME);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

