/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.EType;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncryptedData
implements Cloneable {
    int eType;
    Integer kvno;
    byte[] cipher;
    byte[] plain;
    public static final int ETYPE_NULL = 0;
    public static final int ETYPE_DES_CBC_CRC = 1;
    public static final int ETYPE_DES_CBC_MD4 = 2;
    public static final int ETYPE_DES_CBC_MD5 = 3;
    public static final int ETYPE_ARCFOUR_HMAC = 23;
    public static final int ETYPE_ARCFOUR_HMAC_EXP = 24;
    public static final int ETYPE_DES3_CBC_HMAC_SHA1_KD = 16;
    public static final int ETYPE_AES128_CTS_HMAC_SHA1_96 = 17;
    public static final int ETYPE_AES256_CTS_HMAC_SHA1_96 = 18;

    private EncryptedData() {
    }

    public Object clone() {
        EncryptedData new_encryptedData = new EncryptedData();
        new_encryptedData.eType = this.eType;
        if (this.kvno != null) {
            new_encryptedData.kvno = new Integer(this.kvno);
        }
        if (this.cipher != null) {
            new_encryptedData.cipher = new byte[this.cipher.length];
            System.arraycopy(this.cipher, 0, new_encryptedData.cipher, 0, this.cipher.length);
        }
        return new_encryptedData;
    }

    public EncryptedData(int new_eType, Integer new_kvno, byte[] new_cipher) {
        this.eType = new_eType;
        this.kvno = new_kvno;
        this.cipher = new_cipher;
    }

    public EncryptedData(EncryptionKey key, byte[] plaintext, int usage) throws KdcErrException, KrbCryptoException {
        EType etypeEngine = EType.getInstance(key.getEType());
        this.cipher = etypeEngine.encrypt(plaintext, key.getBytes(), usage);
        this.eType = key.getEType();
        this.kvno = key.getKeyVersionNumber();
    }

    public byte[] decrypt(EncryptionKey key, int usage) throws KdcErrException, KrbApErrException, KrbCryptoException {
        if (this.eType != key.getEType()) {
            throw new KrbCryptoException("EncryptedData is encrypted using keytype " + EType.toString(this.eType) + " but decryption key is of type " + EType.toString(key.getEType()));
        }
        EType etypeEngine = EType.getInstance(this.eType);
        this.plain = etypeEngine.decrypt(this.cipher, key.getBytes(), usage);
        this.cipher = null;
        return etypeEngine.decryptedData(this.plain);
    }

    private byte[] decryptedData() throws KdcErrException {
        if (this.plain != null) {
            EType etypeEngine = EType.getInstance(this.eType);
            return etypeEngine.decryptedData(this.plain);
        }
        return null;
    }

    private EncryptedData(DerValue encoding) throws Asn1Exception, IOException {
        DerValue der = null;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.eType = der.getData().getBigInteger().intValue();
        if ((encoding.getData().peekByte() & 0x1F) == 1) {
            der = encoding.getData().getDerValue();
            int i = der.getData().getBigInteger().intValue();
            this.kvno = new Integer(i);
        } else {
            this.kvno = null;
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 2) {
            throw new Asn1Exception(906);
        }
        this.cipher = der.getData().getOctetString();
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.eType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        if (this.kvno != null) {
            temp.putInteger(BigInteger.valueOf(this.kvno.longValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
            temp = new DerOutputStream();
        }
        temp.putOctetString(this.cipher);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public static EncryptedData parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new EncryptedData(subDer);
    }

    public byte[] reset(byte[] data, boolean encoded) {
        byte[] bytes = null;
        if (encoded) {
            if ((data[1] & 0xFF) < 128) {
                bytes = new byte[data[1] + 2];
                System.arraycopy(data, 0, bytes, 0, data[1] + 2);
            } else if ((data[1] & 0xFF) > 128) {
                int len = data[1] & 0x7F;
                int result = 0;
                for (int i = 0; i < len; ++i) {
                    result |= (data[i + 2] & 0xFF) << 8 * (len - i - 1);
                }
                bytes = new byte[result + len + 2];
                System.arraycopy(data, 0, bytes, 0, result + len + 2);
            }
        } else {
            bytes = new byte[data.length - data[data.length - 1]];
            System.arraycopy(data, 0, bytes, 0, data.length - data[data.length - 1]);
        }
        return bytes;
    }

    public int getEType() {
        return this.eType;
    }

    public Integer getKeyVersionNumber() {
        return this.kvno;
    }

    public byte[] getBytes() {
        return this.cipher;
    }
}

