/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.repository;

import java.lang.reflect.Type;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.parser.SignatureParser;
import sun.reflect.generics.repository.GenericDeclRepository;
import sun.reflect.generics.tree.ClassSignature;
import sun.reflect.generics.tree.ClassTypeSignature;
import sun.reflect.generics.visitor.Reifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRepository
extends GenericDeclRepository<ClassSignature> {
    private Type superclass;
    private Type[] superInterfaces;

    private ClassRepository(String rawSig, GenericsFactory f) {
        super(rawSig, f);
    }

    @Override
    protected ClassSignature parse(String s) {
        return SignatureParser.make().parseClassSig(s);
    }

    public static ClassRepository make(String rawSig, GenericsFactory f) {
        return new ClassRepository(rawSig, f);
    }

    public Type getSuperclass() {
        if (this.superclass == null) {
            Reifier r = this.getReifier();
            ((ClassSignature)this.getTree()).getSuperclass().accept(r);
            this.superclass = r.getResult();
        }
        return this.superclass;
    }

    public Type[] getSuperInterfaces() {
        if (this.superInterfaces == null) {
            ClassTypeSignature[] ts = ((ClassSignature)this.getTree()).getSuperInterfaces();
            Type[] sis = new Type[ts.length];
            for (int i = 0; i < ts.length; ++i) {
                Reifier r = this.getReifier();
                ts[i].accept(r);
                sis[i] = r.getResult();
            }
            this.superInterfaces = sis;
        }
        return (Type[])this.superInterfaces.clone();
    }
}

