/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.image.ByteComponentRaster;
import sun.print.PSPrinterJob;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;

class PSPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;

    PSPathGraphics(Graphics2D graphics, PrinterJob printerJob, Printable painter, PageFormat pageFormat, int pageIndex, boolean canRedraw) {
        super(graphics, printerJob, painter, pageFormat, pageIndex, canRedraw);
    }

    public Graphics create() {
        return new PSPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    public void fill(Shape s, Color color) {
        this.deviceFill(s.getPathIterator(new AffineTransform()), color);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(String str, float x, float y) {
        this.drawString(str, x, y, this.getFont(), this.getFontRenderContext(), 0.0f);
    }

    protected boolean canDrawStringToWidth() {
        return true;
    }

    protected int platformFontCount(Font font, String str) {
        PSPrinterJob psPrinterJob = (PSPrinterJob)this.getPrinterJob();
        return psPrinterJob.platformFontCount(font, str);
    }

    protected void drawString(String str, float x, float y, Font font, FontRenderContext frc, float w) {
        PSPrinterJob psPrinterJob;
        boolean directToPS;
        AffineTransform fontTx;
        int transformType;
        if (str.length() == 0) {
            return;
        }
        if (font.hasLayoutAttributes() && !this.printingGlyphVector) {
            TextLayout layout = new TextLayout(str, font, frc);
            layout.draw(this, x, y);
            return;
        }
        Font oldFont = this.getFont();
        if (!oldFont.equals(font)) {
            this.setFont(font);
        } else {
            oldFont = null;
        }
        boolean drawnWithPS = false;
        float translateX = 0.0f;
        float translateY = 0.0f;
        boolean fontisTransformed = this.getFont().isTransformed();
        if (fontisTransformed && (transformType = (fontTx = this.getFont().getTransform()).getType()) == 1) {
            translateX = (float)fontTx.getTranslateX();
            translateY = (float)fontTx.getTranslateY();
            if ((double)Math.abs(translateX) < 1.0E-5) {
                translateX = 0.0f;
            }
            if ((double)Math.abs(translateY) < 1.0E-5) {
                translateY = 0.0f;
            }
            fontisTransformed = false;
        }
        boolean bl = directToPS = !fontisTransformed;
        if (!PSPrinterJob.shapeTextProp && directToPS && (psPrinterJob = (PSPrinterJob)this.getPrinterJob()).setFont(this.getFont())) {
            try {
                psPrinterJob.setColor((Color)this.getPaint());
            }
            catch (ClassCastException e) {
                if (oldFont != null) {
                    this.setFont(oldFont);
                }
                throw new IllegalArgumentException("Expected a Color instance");
            }
            psPrinterJob.setTransform(this.getTransform());
            psPrinterJob.setClip(this.getClip());
            drawnWithPS = psPrinterJob.textOut(this, str, x + translateX, y + translateY, font, frc, w);
        }
        if (!drawnWithPS) {
            if (oldFont != null) {
                this.setFont(oldFont);
                oldFont = null;
            }
            super.drawString(str, x, y, font, frc, w);
        }
        if (oldFont != null) {
            this.setFont(oldFont);
        }
    }

    protected boolean drawImageToPlatform(Image image, AffineTransform xform, Color bgcolor, int srcX, int srcY, int srcWidth, int srcHeight, boolean handlingTransparency) {
        BufferedImage img = this.getBufferedImage(image);
        if (img == null) {
            return true;
        }
        PSPrinterJob psPrinterJob = (PSPrinterJob)this.getPrinterJob();
        AffineTransform fullTransform = this.getTransform();
        if (xform == null) {
            xform = new AffineTransform();
        }
        fullTransform.concatenate(xform);
        double[] fullMatrix = new double[6];
        fullTransform.getMatrix(fullMatrix);
        Point2D.Float unitVectorX = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float unitVectorY = new Point2D.Float(0.0f, 1.0f);
        fullTransform.deltaTransform(unitVectorX, unitVectorX);
        fullTransform.deltaTransform(unitVectorY, unitVectorY);
        Point2D.Float origin = new Point2D.Float(0.0f, 0.0f);
        double scaleX = unitVectorX.distance(origin);
        double scaleY = unitVectorY.distance(origin);
        double devResX = psPrinterJob.getXRes();
        double devResY = psPrinterJob.getYRes();
        double devScaleX = devResX / 72.0;
        double devScaleY = devResY / 72.0;
        if (scaleX > devScaleX) {
            scaleX = devScaleX;
        }
        if (scaleY > devScaleY) {
            scaleY = devScaleY;
        }
        if (scaleX != 0.0 && scaleY != 0.0) {
            AffineTransform rotTransform = new AffineTransform(fullMatrix[0] / scaleX, fullMatrix[1] / scaleY, fullMatrix[2] / scaleX, fullMatrix[3] / scaleY, fullMatrix[4] / scaleX, fullMatrix[5] / scaleY);
            Rectangle2D.Float srcRect = new Rectangle2D.Float(srcX, srcY, srcWidth, srcHeight);
            Shape rotShape = rotTransform.createTransformedShape(srcRect);
            Rectangle2D rotBounds = rotShape.getBounds2D();
            rotBounds.setRect(rotBounds.getX(), rotBounds.getY(), rotBounds.getWidth() + 0.001, rotBounds.getHeight() + 0.001);
            int boundsWidth = (int)rotBounds.getWidth();
            int boundsHeight = (int)rotBounds.getHeight();
            if (boundsWidth > 0 && boundsHeight > 0) {
                boolean drawOpaque = true;
                if (!handlingTransparency && this.hasTransparentPixels(img)) {
                    drawOpaque = false;
                    if (this.isBitmaskTransparency(img)) {
                        if (bgcolor == null) {
                            if (this.drawBitmaskImage(img, xform, bgcolor, srcX, srcY, srcWidth, srcHeight)) {
                                return true;
                            }
                        } else if (bgcolor.getTransparency() == 1) {
                            drawOpaque = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        drawOpaque = true;
                    }
                } else {
                    bgcolor = null;
                }
                if ((srcX + srcWidth > img.getWidth(null) || srcY + srcHeight > img.getHeight(null)) && this.canDoRedraws()) {
                    drawOpaque = false;
                }
                if (!drawOpaque) {
                    fullTransform.getMatrix(fullMatrix);
                    AffineTransform tx = new AffineTransform(fullMatrix[0] / devScaleX, fullMatrix[1] / devScaleY, fullMatrix[2] / devScaleX, fullMatrix[3] / devScaleY, fullMatrix[4] / devScaleX, fullMatrix[5] / devScaleY);
                    Rectangle2D.Float rect = new Rectangle2D.Float(srcX, srcY, srcWidth, srcHeight);
                    Shape shape = fullTransform.createTransformedShape(rect);
                    Rectangle2D region = shape.getBounds2D();
                    region.setRect(region.getX(), region.getY(), region.getWidth() + 0.001, region.getHeight() + 0.001);
                    int w = (int)region.getWidth();
                    int h = (int)region.getHeight();
                    int nbytes = w * h * 3;
                    int maxBytes = 0x800000;
                    double origDpi = devResX < devResY ? devResX : devResY;
                    int dpi = (int)origDpi;
                    double scaleFactor = 1.0;
                    double maxSFX = (double)w / (double)boundsWidth;
                    double maxSFY = (double)h / (double)boundsHeight;
                    double maxSF = maxSFX > maxSFY ? maxSFY : maxSFX;
                    int minDpi = (int)((double)dpi / maxSF);
                    if (minDpi < 72) {
                        minDpi = 72;
                    }
                    while (nbytes > maxBytes && dpi > minDpi) {
                        scaleFactor *= 2.0;
                        dpi /= 2;
                        nbytes /= 4;
                    }
                    if (dpi < minDpi) {
                        scaleFactor = origDpi / (double)minDpi;
                    }
                    region.setRect(region.getX() / scaleFactor, region.getY() / scaleFactor, region.getWidth() / scaleFactor, region.getHeight() / scaleFactor);
                    psPrinterJob.saveState(this.getTransform(), this.getClip(), region, scaleFactor, scaleFactor);
                    return true;
                }
                BufferedImage deepImage = new BufferedImage((int)rotBounds.getWidth(), (int)rotBounds.getHeight(), 5);
                Graphics2D imageGraphics = deepImage.createGraphics();
                imageGraphics.clipRect(0, 0, deepImage.getWidth(), deepImage.getHeight());
                imageGraphics.translate(-rotBounds.getX(), -rotBounds.getY());
                imageGraphics.transform(rotTransform);
                if (bgcolor == null) {
                    bgcolor = Color.white;
                }
                imageGraphics.drawImage(img, srcX, srcY, srcX + srcWidth, srcY + srcHeight, srcX, srcY, srcX + srcWidth, srcY + srcHeight, bgcolor, null);
                Shape holdClip = this.getClip();
                Shape oldClip = this.getTransform().createTransformedShape(holdClip);
                AffineTransform sat = AffineTransform.getScaleInstance(scaleX, scaleY);
                Shape imgClip = sat.createTransformedShape(rotShape);
                Area imgArea = new Area(imgClip);
                Area oldArea = new Area(oldClip);
                imgArea.intersect(oldArea);
                psPrinterJob.setClip(imgArea);
                Rectangle2D.Float scaledBounds = new Rectangle2D.Float((float)(rotBounds.getX() * scaleX), (float)(rotBounds.getY() * scaleY), (float)(rotBounds.getWidth() * scaleX), (float)(rotBounds.getHeight() * scaleY));
                ByteComponentRaster tile = (ByteComponentRaster)deepImage.getRaster();
                psPrinterJob.drawImageBGR(tile.getDataStorage(), scaledBounds.x, scaledBounds.y, (float)Math.rint((double)scaledBounds.width + 0.5), (float)Math.rint((double)scaledBounds.height + 0.5), 0.0f, 0.0f, deepImage.getWidth(), deepImage.getHeight(), deepImage.getWidth(), deepImage.getHeight());
                psPrinterJob.setClip(this.getTransform().createTransformedShape(holdClip));
                imageGraphics.dispose();
            }
        }
        return true;
    }

    public void redrawRegion(Rectangle2D region, double scaleX, double scaleY, Shape savedClip, AffineTransform savedTransform) throws PrinterException {
        PSPrinterJob psPrinterJob = (PSPrinterJob)this.getPrinterJob();
        Printable painter = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int pageIndex = this.getPageIndex();
        BufferedImage deepImage = new BufferedImage((int)region.getWidth(), (int)region.getHeight(), 5);
        Graphics2D g = deepImage.createGraphics();
        ProxyGraphics2D proxy = new ProxyGraphics2D(g, psPrinterJob);
        proxy.setColor(Color.white);
        proxy.fillRect(0, 0, deepImage.getWidth(), deepImage.getHeight());
        proxy.clipRect(0, 0, deepImage.getWidth(), deepImage.getHeight());
        proxy.translate(-region.getX(), -region.getY());
        float sourceResX = (float)(psPrinterJob.getXRes() / scaleX);
        float sourceResY = (float)(psPrinterJob.getYRes() / scaleY);
        proxy.scale(sourceResX / 72.0f, sourceResY / 72.0f);
        proxy.translate(-psPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / psPrinterJob.getXRes() * 72.0, -psPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / psPrinterJob.getYRes() * 72.0);
        proxy.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxy.setPaint(Color.black);
        painter.print(proxy, pageFormat, pageIndex);
        g.dispose();
        psPrinterJob.setClip(savedTransform.createTransformedShape(savedClip));
        Rectangle2D.Float scaledBounds = new Rectangle2D.Float((float)(region.getX() * scaleX), (float)(region.getY() * scaleY), (float)(region.getWidth() * scaleX), (float)(region.getHeight() * scaleY));
        ByteComponentRaster tile = (ByteComponentRaster)deepImage.getRaster();
        psPrinterJob.drawImageBGR(tile.getDataStorage(), scaledBounds.x, scaledBounds.y, scaledBounds.width, scaledBounds.height, 0.0f, 0.0f, deepImage.getWidth(), deepImage.getHeight(), deepImage.getWidth(), deepImage.getHeight());
    }

    protected void deviceFill(PathIterator pathIter, Color color) {
        PSPrinterJob psPrinterJob = (PSPrinterJob)this.getPrinterJob();
        psPrinterJob.deviceFill(pathIter, color, this.getTransform(), this.getClip());
    }

    protected void deviceFrameRect(int x, int y, int width, int height, Color color) {
        this.draw(new Rectangle2D.Float(x, y, width, height));
    }

    protected void deviceDrawLine(int xBegin, int yBegin, int xEnd, int yEnd, Color color) {
        this.draw(new Line2D.Float(xBegin, yBegin, xEnd, yEnd));
    }

    protected void deviceFillRect(int x, int y, int width, int height, Color color) {
        this.fill(new Rectangle2D.Float(x, y, width, height));
    }

    protected void deviceClip(PathIterator pathIter) {
    }
}

