/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Util;

class Net {
    private Net() {
    }

    static InetSocketAddress checkAddress(SocketAddress sa) {
        if (sa == null) {
            throw new IllegalArgumentException();
        }
        if (!(sa instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress isa = (InetSocketAddress)sa;
        if (isa.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        InetAddress addr = isa.getAddress();
        if (!(addr instanceof Inet4Address) && !(addr instanceof Inet6Address)) {
            throw new IllegalArgumentException("Invalid address type");
        }
        return isa;
    }

    static InetSocketAddress asInetSocketAddress(SocketAddress sa) {
        if (!(sa instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        return (InetSocketAddress)sa;
    }

    static void translateToSocketException(Exception x) throws SocketException {
        if (x instanceof SocketException) {
            throw (SocketException)x;
        }
        Exception nx = x;
        if (x instanceof ClosedChannelException) {
            nx = new SocketException("Socket is closed");
        } else if (x instanceof AlreadyBoundException) {
            nx = new SocketException("Already bound");
        } else if (x instanceof NotYetBoundException) {
            nx = new SocketException("Socket is not bound yet");
        } else if (x instanceof UnsupportedAddressTypeException) {
            nx = new SocketException("Unsupported address type");
        } else if (x instanceof UnresolvedAddressException) {
            nx = new SocketException("Unresolved address");
        }
        if (nx != x) {
            nx.initCause(x);
        }
        if (nx instanceof SocketException) {
            throw (SocketException)nx;
        }
        if (nx instanceof RuntimeException) {
            throw (RuntimeException)nx;
        }
        throw new Error("Untranslated exception", nx);
    }

    static void translateException(Exception x, boolean unknownHostForUnresolved) throws IOException {
        if (x instanceof IOException) {
            throw (IOException)x;
        }
        if (unknownHostForUnresolved && x instanceof UnresolvedAddressException) {
            throw new UnknownHostException();
        }
        Net.translateToSocketException(x);
    }

    static void translateException(Exception x) throws IOException {
        Net.translateException(x, false);
    }

    static FileDescriptor socket(boolean stream) {
        return IOUtil.newFD(Net.socket0(stream, false));
    }

    static FileDescriptor serverSocket(boolean stream) {
        return IOUtil.newFD(Net.socket0(stream, true));
    }

    private static native int socket0(boolean var0, boolean var1);

    static native void bind(FileDescriptor var0, InetAddress var1, int var2) throws IOException;

    static native int connect(FileDescriptor var0, InetAddress var1, int var2, int var3) throws IOException;

    private static native int localPort(FileDescriptor var0) throws IOException;

    private static native InetAddress localInetAddress(FileDescriptor var0) throws IOException;

    static InetSocketAddress localAddress(FileDescriptor fd) {
        try {
            return new InetSocketAddress(Net.localInetAddress(fd), Net.localPort(fd));
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    static int localPortNumber(FileDescriptor fd) {
        try {
            return Net.localPort(fd);
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    private static native int getIntOption0(FileDescriptor var0, int var1) throws IOException;

    static int getIntOption(FileDescriptor fd, int opt) throws IOException {
        return Net.getIntOption0(fd, opt);
    }

    private static native void setIntOption0(FileDescriptor var0, int var1, int var2) throws IOException;

    static void setIntOption(FileDescriptor fd, int opt, int arg) throws IOException {
        Net.setIntOption0(fd, opt, arg);
    }

    private static native void initIDs();

    static {
        Util.load();
        Net.initIDs();
    }
}

